/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

@GridInternal
public class CheckCpHistTask
extends ComputeTaskAdapter<Map<UUID, Map<Integer, Set<Integer>>>, Boolean> {
    private static final long serialVersionUID = 0L;
    public static final String CP_REASON = "required by another node which is performing a graceful shutdown";

    @Override
    public Map<CheckCpHistClosureJob, ClusterNode> map(List<ClusterNode> subgrid, Map<UUID, Map<Integer, Set<Integer>>> arg) throws IgniteException {
        HashMap<CheckCpHistClosureJob, ClusterNode> res = new HashMap<CheckCpHistClosureJob, ClusterNode>();
        for (ClusterNode node : subgrid) {
            if (!arg.containsKey(node.id())) continue;
            res.put(new CheckCpHistClosureJob(arg.get(node.id())), node);
        }
        return res;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        if (res.getException() != null) {
            return super.result(res, rcvd);
        }
        if (!((Boolean)res.getData()).booleanValue()) {
            return ComputeJobResultPolicy.REDUCE;
        }
        return ComputeJobResultPolicy.WAIT;
    }

    @Override
    public Boolean reduce(List<ComputeJobResult> results) throws IgniteException {
        for (ComputeJobResult result : results) {
            if (((Boolean)result.getData()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static class CheckCpHistClosureJob
    implements ComputeJob {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        private IgniteLogger log;
        @IgniteInstanceResource
        private Ignite ignite;
        private volatile boolean cancelled;
        Map<Integer, Set<Integer>> grpIds;

        public CheckCpHistClosureJob(Map<Integer, Set<Integer>> grpIds) {
            this.grpIds = grpIds;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public Boolean execute() throws IgniteException {
            IgniteEx igniteEx = (IgniteEx)this.ignite;
            if (igniteEx.context().cache().context().database() instanceof GridCacheDatabaseSharedManager) {
                GridCacheSharedContext cctx = igniteEx.context().cache().context();
                GridCacheDatabaseSharedManager dbMng = (GridCacheDatabaseSharedManager)cctx.database();
                CheckpointHistory cpHist = dbMng.checkpointHistory();
                CheckpointEntry lastCp = cpHist.lastCheckpoint();
                try {
                    Map<Integer, CheckpointEntry.GroupState> states = lastCp.groupState(cctx.wal());
                    block2: for (Integer grpId : this.grpIds.keySet()) {
                        if (this.cancelled) {
                            return false;
                        }
                        if (!cpHist.isCheckpointApplicableForGroup(grpId, lastCp)) {
                            dbMng.forceCheckpoint(CheckCpHistTask.CP_REASON);
                            break;
                        }
                        CheckpointEntry.GroupState grpState = states.get(grpId);
                        for (int p : this.grpIds.get(grpId)) {
                            if (grpState.indexByPartition(p) >= 0) continue;
                            dbMng.forceCheckpoint(CheckCpHistTask.CP_REASON);
                            continue block2;
                        }
                    }
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Can not read checkpoint [cp=" + lastCp.checkpointId() + "]", e);
                    return false;
                }
            }
            return true;
        }
    }
}

