/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.store;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.store.GridCacheStoreManagerAdapter;
import org.apache.ignite.internal.processors.cache.store.GridCacheWriteBehindStore;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.cache.store.PlatformCacheStore;

public class CacheOsStoreManager
extends GridCacheStoreManagerAdapter {
    private final GridKernalContext ctx;
    private final CacheConfiguration cfg;

    public CacheOsStoreManager(GridKernalContext ctx, CacheConfiguration cfg) {
        this.ctx = ctx;
        this.cfg = cfg;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        if (this.configured()) {
            CacheStore<?, ?> store = this.configuredStore();
            assert (store != null);
            assert (!(store instanceof GridCacheWriteBehindStore));
            if (store instanceof PlatformCacheStore) {
                PlatformProcessor proc = this.ctx.platform();
                proc.registerStore((PlatformCacheStore)((Object)store), this.configuredConvertBinary());
            }
        }
        super.start0();
    }

    @Override
    protected GridKernalContext igniteContext() {
        return this.ctx;
    }

    @Override
    protected CacheConfiguration cacheConfiguration() {
        return this.cfg;
    }

    @Override
    public boolean convertBinary() {
        if (this.alwaysKeepBinary) {
            return false;
        }
        return this.configuredConvertBinary() && !(this.cfgStore instanceof PlatformCacheStore);
    }

    @Override
    public boolean configuredConvertBinary() {
        return !(this.ctx.config().getMarshaller() instanceof BinaryMarshaller) || this.cfg.isStoreKeepBinary() == false;
    }
}

