/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.event;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.projections.EmailQueryViewManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.DateTimeFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PopulateEmailQueryViewListener
implements EventListener.ReactiveGroupEventListener {
    static final Group GROUP = new PopulateEmailQueryViewListenerGroup();
    private static final int CONCURRENCY = 5;
    private final MessageIdManager messageIdManager;
    private final EmailQueryViewManager viewManager;
    private final SessionProvider sessionProvider;

    @Inject
    public PopulateEmailQueryViewListener(MessageIdManager messageIdManager, EmailQueryViewManager viewManager, SessionProvider sessionProvider) {
        this.messageIdManager = messageIdManager;
        this.viewManager = viewManager;
        this.sessionProvider = sessionProvider;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.FlagsUpdated || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Added) {
            return this.handleAdded((MailboxEvents.Added)event);
        }
        if (event instanceof MailboxEvents.Expunged) {
            return this.handleExpunged((MailboxEvents.Expunged)event);
        }
        if (event instanceof MailboxEvents.FlagsUpdated) {
            return this.handleFlagsUpdated((MailboxEvents.FlagsUpdated)event);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.handleMailboxDeletion((MailboxEvents.MailboxDeletion)event);
        }
        return Mono.empty();
    }

    private Publisher<Void> handleMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion) {
        return this.viewManager.getEmailQueryView(mailboxDeletion.getUsername()).delete(mailboxDeletion.getMailboxId());
    }

    private Publisher<Void> handleExpunged(MailboxEvents.Expunged expunged) {
        return Flux.fromStream(expunged.getUids().stream().map(uid -> expunged.getMetaData(uid).getMessageId())).concatMap(messageId -> this.viewManager.getEmailQueryView(expunged.getUsername()).delete(expunged.getMailboxId(), messageId)).then();
    }

    private Publisher<Void> handleFlagsUpdated(MailboxEvents.FlagsUpdated flagsUpdated) {
        MailboxSession session = this.sessionProvider.createSystemSession(flagsUpdated.getUsername());
        Mono removeMessagesMarkedAsDeleted = Flux.fromIterable((Iterable)flagsUpdated.getUpdatedFlags()).filter(updatedFlags -> updatedFlags.isModifiedToSet(Flags.Flag.DELETED)).map(UpdatedFlags::getMessageId).handle(ReactorUtils.publishIfPresent()).concatMap(messageId -> this.viewManager.getEmailQueryView(flagsUpdated.getUsername()).delete(flagsUpdated.getMailboxId(), messageId)).then();
        Mono addMessagesNoLongerMarkedAsDeleted = Flux.fromIterable((Iterable)flagsUpdated.getUpdatedFlags()).filter(updatedFlags -> updatedFlags.isModifiedToUnset(Flags.Flag.DELETED)).map(UpdatedFlags::getMessageId).handle(ReactorUtils.publishIfPresent()).concatMap(messageId -> Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)messageId), FetchGroup.HEADERS, session)).next()).concatMap(message -> this.handleAdded(flagsUpdated.getMailboxId(), (MessageResult)message, flagsUpdated.getUsername())).then();
        return removeMessagesMarkedAsDeleted.then(addMessagesNoLongerMarkedAsDeleted);
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added) {
        MailboxSession session = this.sessionProvider.createSystemSession(added.getUsername());
        return Flux.fromStream(added.getUids().stream().map(arg_0 -> ((MailboxEvents.Added)added).getMetaData(arg_0))).flatMap(messageMetaData -> this.handleAdded(added, (MessageMetaData)messageMetaData, session), 5).then();
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added, MessageMetaData messageMetaData, MailboxSession session) {
        MessageId messageId = messageMetaData.getMessageId();
        MailboxId mailboxId = added.getMailboxId();
        Mono doHandleAdded = Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)messageId), FetchGroup.HEADERS, session)).next().filter(message -> !message.getFlags().contains(Flags.Flag.DELETED)).flatMap(messageResult -> this.handleAdded(added.getMailboxId(), (MessageResult)messageResult, added.getUsername()));
        if (Role.from((String)added.getMailboxPath().getName()).equals(Optional.of(Role.OUTBOX))) {
            return this.checkMessageStillInOriginMailbox(messageId, session, mailboxId).filter(FunctionalUtils.identityPredicate()).flatMap(stillInOriginMailbox -> doHandleAdded);
        }
        return doHandleAdded;
    }

    private Mono<Boolean> checkMessageStillInOriginMailbox(MessageId messageId, MailboxSession session, MailboxId targetMailboxId) {
        return Flux.from((Publisher)this.messageIdManager.messageMetadata(messageId, session)).filter(composedMessageIdWithMetaData -> composedMessageIdWithMetaData.getComposedMessageId().getMailboxId().equals((Object)targetMailboxId)).hasElements();
    }

    public Mono<Void> handleAdded(MailboxId mailboxId, MessageResult messageResult, Username username) {
        ZonedDateTime receivedAt = ZonedDateTime.ofInstant(messageResult.getInternalDate().toInstant(), ZoneOffset.UTC);
        return Mono.fromCallable(() -> this.parseMessage(messageResult)).map(header -> this.date((Header)header).orElse(messageResult.getInternalDate())).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC)).flatMap(sentAt -> this.viewManager.getEmailQueryView(username).save(mailboxId, sentAt, receivedAt, messageResult.getMessageId())).then();
    }

    private Header parseMessage(MessageResult messageResult) throws IOException, MailboxException {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        return defaultMessageBuilder.parseHeader(messageResult.getFullContent().getInputStream());
    }

    private Optional<Date> date(Header header) {
        return Optional.ofNullable(header.getField("Date")).map(field -> (DateTimeField)DateTimeFieldLenientImpl.PARSER.parse(field, DecodeMonitor.SILENT)).map(DateTimeField::getDate);
    }

    public static class PopulateEmailQueryViewListenerGroup
    extends Group {
    }
}

