/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.change;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.stream.Collector;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.postgres.change.PostgresEmailChangeDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresEmailChangeRepository
implements EmailChangeRepository {
    public static final String LIMIT_NAME = "emailChangeDefaultLimit";
    private final PostgresExecutor.Factory executorFactory;
    private final Limit defaultLimit;

    @Inject
    public PostgresEmailChangeRepository(PostgresExecutor.Factory executorFactory, @Named(value="emailChangeDefaultLimit") Limit defaultLimit) {
        this.executorFactory = executorFactory;
        this.defaultLimit = defaultLimit;
    }

    public Mono<Void> save(EmailChange change) {
        PostgresEmailChangeDAO emailChangeDAO = this.createPostgresEmailChangeDAO(change.getAccountId());
        return emailChangeDAO.insert(change);
    }

    public Mono<EmailChanges> getSinceState(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        PostgresEmailChangeDAO emailChangeDAO = this.createPostgresEmailChangeDAO(accountId);
        if (state.equals((Object)State.INITIAL)) {
            return emailChangeDAO.getAllChanges(accountId).filter(change -> !change.isShared()).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return emailChangeDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.isShared()).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<EmailChanges> getSinceStateWithDelegation(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        PostgresEmailChangeDAO emailChangeDAO = this.createPostgresEmailChangeDAO(accountId);
        if (state.equals((Object)State.INITIAL)) {
            return emailChangeDAO.getAllChanges(accountId).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return emailChangeDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<State> getLatestState(AccountId accountId) {
        PostgresEmailChangeDAO emailChangeDAO = this.createPostgresEmailChangeDAO(accountId);
        return emailChangeDAO.latestStateNotDelegated(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }

    public Mono<State> getLatestStateWithDelegation(AccountId accountId) {
        PostgresEmailChangeDAO emailChangeDAO = this.createPostgresEmailChangeDAO(accountId);
        return emailChangeDAO.latestState(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }

    private PostgresEmailChangeDAO createPostgresEmailChangeDAO(AccountId accountId) {
        return new PostgresEmailChangeDAO(this.executorFactory.create(Username.of((String)accountId.getIdentifier()).getDomainPart()));
    }
}

