/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.math.BigDecimal;

public class XSDNumUtils {
    public static double xsdParseDouble(String lexicalForm) {
        return switch (lexicalForm) {
            case "INF", "inf" -> Double.POSITIVE_INFINITY;
            case "+INF", "+inf" -> Double.POSITIVE_INFINITY;
            case "-INF", "-inf" -> Double.NEGATIVE_INFINITY;
            case "NaN" -> Double.NaN;
            case "-NaN" -> throw new NumberFormatException("-NaN is not valid as an xsd:double");
            case "+NaN" -> throw new NumberFormatException("+NaN is not valid as an xsd:double");
            default -> Double.parseDouble(lexicalForm);
        };
    }

    public static float xsdParseFloat(String lexicalForm) {
        return switch (lexicalForm) {
            case "INF", "inf" -> Float.POSITIVE_INFINITY;
            case "+INF", "+inf" -> Float.POSITIVE_INFINITY;
            case "-INF", "-inf" -> Float.NEGATIVE_INFINITY;
            case "NaN" -> Float.NaN;
            case "-NaN" -> throw new NumberFormatException("-NaN is not valid as an xsd:float");
            case "+NaN" -> throw new NumberFormatException("+NaN is not valid as an xsd:float");
            default -> Float.parseFloat(lexicalForm);
        };
    }

    public static BigDecimal xsdParseDecimal(String lexicalForm) {
        return new BigDecimal(lexicalForm);
    }

    public static String stringForm(BigDecimal decimal) {
        return XSDNumUtils.canonicalDecimalStrWithDot(decimal);
    }

    public static String stringForm(double d) {
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return "-INF";
            }
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        String x = Double.toString(d);
        if (x.indexOf(101) != -1 || x.indexOf(69) != -1) {
            return x;
        }
        return x + "e0";
    }

    public static String stringForm(float f) {
        if (Float.isInfinite(f)) {
            if (f < 0.0f) {
                return "-INF";
            }
            return "INF";
        }
        if (Float.isNaN(f)) {
            return "NaN";
        }
        String x = Float.toString(f);
        return x;
    }

    public static String stringFormatARQ(BigDecimal bd) {
        return XSDNumUtils.canonicalDecimalStrWithDot(bd);
    }

    public static String stringFormatXSD10(BigDecimal bd) {
        return XSDNumUtils.canonicalDecimalStrWithDot(bd);
    }

    public static String stringFormatXSD11(BigDecimal bd) {
        return XSDNumUtils.canonicalDecimalStrNoIntegerDot(bd);
    }

    public static String canonicalDecimalStrNoIntegerDot(BigDecimal bd) {
        if (bd.signum() == 0) {
            return "0";
        }
        if (bd.scale() <= 0) {
            return bd.toPlainString();
        }
        return bd.stripTrailingZeros().toPlainString();
    }

    public static String canonicalDecimalStrWithDot(BigDecimal decimal) {
        if (decimal.signum() == 0) {
            return "0.0";
        }
        if (decimal.scale() <= 0) {
            return decimal.toPlainString() + ".0";
        }
        Object str2 = decimal.stripTrailingZeros().toPlainString();
        int dotIdx = ((String)str2).indexOf(46);
        if (dotIdx < 0) {
            str2 = (String)str2 + ".0";
        }
        return str2;
    }
}

