/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.CompositionBase;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class UnionGraphImpl
extends CompositionBase
implements UnionGraph {
    protected final Graph base;
    protected final SubGraphs subGraphs;
    protected final boolean distinct;
    protected final Set<UnionGraphImpl> parents = Collections.newSetFromMap(new WeakHashMap());
    protected Set<Graph> descendantBases;

    public UnionGraphImpl(Graph base) {
        this(base, true);
    }

    public UnionGraphImpl(Graph base, boolean distinct) {
        this(base, new EventManagerImpl(), distinct);
    }

    public UnionGraphImpl(Graph base, UnionGraph.EventManager eventManager, boolean distinct) {
        this(base, new SubGraphs(), eventManager, distinct);
    }

    protected UnionGraphImpl(Graph base, SubGraphs subGraphs, UnionGraph.EventManager eventManager, boolean distinct) {
        this.base = Objects.requireNonNull(base, "Null base graph.");
        this.subGraphs = Objects.requireNonNull(subGraphs, "Null SubGraphs");
        this.gem = Objects.requireNonNull(eventManager, "Null EventManager");
        this.distinct = distinct;
    }

    public PrefixMapping getPrefixMapping() {
        return this.getBaseGraph().getPrefixMapping();
    }

    @Override
    public UnionGraph.EventManager getEventManager() {
        return (UnionGraph.EventManager)this.gem;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Graph getBaseGraph() {
        return this.base;
    }

    public SubGraphs getSubGraphs() {
        return this.subGraphs;
    }

    @Override
    public boolean hasSubGraph() {
        return !this.getSubGraphs().isEmpty();
    }

    @Override
    public Stream<Graph> subGraphs() {
        return this.getSubGraphs().graphs();
    }

    @Override
    public Stream<UnionGraph> superGraphs() {
        return this.parents.stream().map(it -> it);
    }

    public void performAdd(Triple t) {
        this.getEventManager().onAddTriple(this, t);
        if (!this.subGraphs.contains(t)) {
            this.base.add(t);
        }
    }

    public void performDelete(Triple t) {
        this.getEventManager().onDeleteTriple(this, t);
        this.base.delete(t);
    }

    public void remove(Node s, Node p, Node o) {
        this.checkOpen();
        Triple t = Triple.createMatch((Node)s, (Node)p, (Node)o);
        UnionGraph.EventManager em = this.getEventManager();
        em.onDeleteTriple(this, t);
        GraphUtil.remove((Graph)this, (Node)s, (Node)p, (Node)o);
        em.notifyEvent(this, GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }

    public void clear() {
        this.checkOpen();
        UnionGraph.EventManager em = this.getEventManager();
        em.onClear(this);
        this.base.clear();
        em.notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public UnionGraph addSubGraph(Graph graph) {
        Objects.requireNonNull(graph);
        this.checkOpen();
        UnionGraph.EventManager eventManager = this.getEventManager();
        eventManager.onAddSubGraph(this, graph);
        this.getSubGraphs().add(graph);
        this.addParent(graph);
        this.resetGraphsCache();
        eventManager.notifySubGraphAdded(this, graph);
        if (graph instanceof UnionGraph) {
            UnionGraph subGraph = (UnionGraph)graph;
            subGraph.getEventManager().notifySuperGraphAdded(subGraph, this);
        }
        return this;
    }

    protected void addParent(Graph graph) {
        if (!(graph instanceof UnionGraphImpl)) {
            return;
        }
        ((UnionGraphImpl)graph).parents.add(this);
    }

    @Override
    public UnionGraph removeSubGraph(Graph graph) {
        Objects.requireNonNull(graph);
        this.checkOpen();
        UnionGraph.EventManager eventManager = this.getEventManager();
        eventManager.onRemoveSubGraph(this, graph);
        this.getSubGraphs().remove(graph);
        this.removeUnion(graph);
        this.resetGraphsCache();
        eventManager.notifySubGraphRemoved(this, graph);
        return this;
    }

    protected void removeUnion(Graph graph) {
        if (!(graph instanceof UnionGraphImpl)) {
            return;
        }
        ((UnionGraphImpl)graph).parents.remove(this);
    }

    protected void resetGraphsCache() {
        this.getAllLinkedUnionGraphs().forEach(x -> {
            x.descendantBases = null;
        });
    }

    public ExtendedIterator<Graph> listSubGraphBases() {
        return Iterators.create(this.descendantBases == null ? (this.descendantBases = this.getAllBaseGraphs()) : this.descendantBases);
    }

    protected final ExtendedIterator<Triple> graphBaseFind(Triple m) {
        return SimpleEventManager.notifyingRemove((Graph)this, this.createFindIterator(m));
    }

    public boolean graphBaseContains(Triple t) {
        if (this.base.contains(t)) {
            return true;
        }
        if (this.subGraphs.isEmpty()) {
            return false;
        }
        ExtendedIterator<Graph> graphs = this.listSubGraphBases();
        while (graphs.hasNext()) {
            Graph g = (Graph)graphs.next();
            if (g == this.base || !g.contains(t)) continue;
            return true;
        }
        return false;
    }

    public int graphBaseSize() {
        if (this.subGraphs.isEmpty()) {
            return this.base.size();
        }
        return super.graphBaseSize();
    }

    public boolean isEmpty() {
        if (this.subGraphs.isEmpty()) {
            return this.base.isEmpty();
        }
        return Iterators.findFirst(this.find()).isEmpty();
    }

    protected ExtendedIterator<Triple> createFindIterator(Triple m) {
        if (this.subGraphs.isEmpty()) {
            return this.base.find(m);
        }
        if (!this.distinct) {
            return Iterators.flatMap(this.listSubGraphBases(), x -> x.find(m));
        }
        Set<Triple> seen = this.createSet();
        return Iterators.flatMap(this.listSubGraphBases(), x -> CompositionBase.recording((ClosableIterator)UnionGraphImpl.rejecting((ExtendedIterator)x.find(m), (Set)seen), (Set)seen));
    }

    protected Set<Triple> createSet() {
        return new HashSet<Triple>();
    }

    public void close() {
        this.listSubGraphBases().forEachRemaining(Graph::close);
        this.getAllUnderlyingUnionGraphs().forEach(x -> {
            x.closed = true;
        });
    }

    public boolean dependsOn(Graph other) {
        return other instanceof UnionGraphImpl && this.getAllUnderlyingUnionGraphs().contains(other) || Iterators.anyMatch(this.listSubGraphBases(), x -> Graphs.dependsOn(x, other));
    }

    protected Set<Graph> getAllBaseGraphs() {
        LinkedHashSet<Graph> res = new LinkedHashSet<Graph>();
        HashSet<UnionGraphImpl> visited = new HashSet<UnionGraphImpl>();
        ArrayDeque<Graph> queue = new ArrayDeque<Graph>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Graph next = (Graph)queue.removeFirst();
            if (next instanceof UnionGraphImpl) {
                UnionGraphImpl u = (UnionGraphImpl)next;
                if (!visited.add(u)) continue;
                queue.add(u.base);
                queue.addAll(u.subGraphs.graphs);
                continue;
            }
            res.add(next);
        }
        return res;
    }

    protected Set<UnionGraphImpl> getAllLinkedUnionGraphs() {
        LinkedHashSet<UnionGraphImpl> res = new LinkedHashSet<UnionGraphImpl>();
        ArrayDeque<UnionGraphImpl> queue = new ArrayDeque<UnionGraphImpl>();
        queue.add(this);
        while (!queue.isEmpty()) {
            UnionGraphImpl next = (UnionGraphImpl)queue.removeFirst();
            if (!res.add(next)) continue;
            next.parents.stream().filter(res::add).forEach(queue::add);
            next.getAllUnderlyingUnionGraphs().stream().filter(res::add).forEach(queue::add);
        }
        return res;
    }

    protected Set<UnionGraphImpl> getAllUnderlyingUnionGraphs() {
        LinkedHashSet<UnionGraphImpl> res = new LinkedHashSet<UnionGraphImpl>();
        ArrayDeque<UnionGraphImpl> queue = new ArrayDeque<UnionGraphImpl>();
        queue.add(this);
        while (!queue.isEmpty()) {
            UnionGraphImpl next = (UnionGraphImpl)queue.removeFirst();
            if (!res.add(next)) continue;
            next.unionSubGraphs().forEach(queue::add);
        }
        return res;
    }

    private Stream<UnionGraphImpl> unionSubGraphs() {
        return this.getSubGraphs().graphs().filter(g -> g instanceof UnionGraphImpl).map(u -> (UnionGraphImpl)u);
    }

    public String toString() {
        return "UnionGraph{@" + this.hashCode() + "}";
    }

    public static class EventManagerImpl
    extends SimpleEventManager
    implements UnionGraph.EventManager {
        private final List<GraphListener> inactive = new ArrayList<GraphListener>();

        @Override
        public void onAddTriple(UnionGraph graph, Triple triple) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.onAddTriple(graph, triple));
        }

        @Override
        public void onDeleteTriple(UnionGraph graph, Triple triple) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.onDeleteTriple(graph, triple));
        }

        @Override
        public void onAddSubGraph(UnionGraph graph, Graph subGraph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.onAddSubGraph(graph, subGraph));
        }

        @Override
        public void onClear(UnionGraph graph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.onClear(graph));
        }

        @Override
        public void notifySubGraphAdded(UnionGraph graph, Graph subGraph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySubGraphAdded(graph, subGraph));
        }

        @Override
        public void notifySuperGraphAdded(UnionGraph graph, UnionGraph superGraph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySuperGraphAdded(graph, superGraph));
        }

        @Override
        public void onRemoveSubGraph(UnionGraph graph, Graph subGraph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.onRemoveSubGraph(graph, subGraph));
        }

        @Override
        public void notifySubGraphRemoved(UnionGraph graph, Graph subGraph) {
            this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySubGraphRemoved(graph, subGraph));
        }

        @Override
        public void off() {
            this.inactive.addAll(this.listeners);
            this.listeners.clear();
        }

        @Override
        public void on() {
            this.listeners.addAll(this.inactive);
            this.inactive.clear();
        }

        @Override
        public Stream<GraphListener> listeners() {
            return this.listeners.stream();
        }
    }

    public static class SubGraphs {
        protected final Collection<Graph> graphs;

        protected SubGraphs() {
            this(new ArrayList<Graph>());
        }

        protected SubGraphs(Collection<Graph> graphs) {
            this.graphs = Objects.requireNonNull(graphs);
        }

        public ExtendedIterator<Graph> listGraphs() {
            return Iterators.create(this.graphs);
        }

        public Stream<Graph> graphs() {
            return this.graphs.stream();
        }

        public boolean isEmpty() {
            return this.graphs.isEmpty();
        }

        public void remove(Graph graph) {
            this.graphs.remove(graph);
        }

        public void add(Graph graph) {
            this.graphs.add(Objects.requireNonNull(graph));
        }

        protected boolean contains(Triple t) {
            if (this.graphs.isEmpty()) {
                return false;
            }
            for (Graph g : this.graphs) {
                if (!g.contains(t)) continue;
                return true;
            }
            return false;
        }
    }
}

