/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

public enum ResourceType {
    Controller("/controller"),
    ControllerService("/controller-services"),
    Counters("/counters"),
    Funnel("/funnels"),
    Flow("/flow"),
    InputPort("/input-ports"),
    Label("/labels"),
    OutputPort("/output-ports"),
    Policy("/policies"),
    Processor("/processors"),
    ProcessGroup("/process-groups"),
    Provenance("/provenance"),
    ProvenanceData("/provenance-data"),
    Data("/data"),
    Proxy("/proxy"),
    RemoteProcessGroup("/remote-process-groups"),
    ReportingTask("/reporting-tasks"),
    FlowAnalysisRule("/controller/flow-analysis-rules"),
    RegistryClient("/controller/registry-clients"),
    Resource("/resources"),
    SiteToSite("/site-to-site"),
    DataTransfer("/data-transfer"),
    System("/system"),
    RestrictedComponents("/restricted-components"),
    Operation("/operation"),
    Tenant("/tenants"),
    ParameterContext("/parameter-contexts"),
    ParameterProvider("/parameter-providers");

    final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static ResourceType fromRawValue(String rawValue) throws IllegalArgumentException {
        for (ResourceType rt : ResourceType.values()) {
            if (!rt.getValue().equals(rawValue) && !rawValue.startsWith(rt.getValue() + "/")) continue;
            return rt;
        }
        return null;
    }
}

