/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.security.ssl.TrustManagerListener;

public class StandardX509ExtendedTrustManager
extends X509ExtendedTrustManager
implements TrustManagerListener {
    private final AtomicReference<X509ExtendedTrustManager> trustManagerRef;

    public StandardX509ExtendedTrustManager(X509ExtendedTrustManager trustManager) {
        Objects.requireNonNull(trustManager, "Trust Manager required");
        this.trustManagerRef = new AtomicReference<X509ExtendedTrustManager>(trustManager);
    }

    @Override
    public void setTrustManager(X509ExtendedTrustManager trustManager) {
        Objects.requireNonNull(trustManager, "Trust Manager required");
        this.trustManagerRef.lazySet(trustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManagerRef.get().checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManagerRef.get().checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.trustManagerRef.get().checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.trustManagerRef.get().checkServerTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManagerRef.get().checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManagerRef.get().checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManagerRef.get().getAcceptedIssuers();
    }
}

