/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ObservationAuthenticationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.observation.SecurityObservationSettings;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.ObservationFilterChainDecorator;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
class ObservationConfiguration {
    private static final SecurityObservationSettings all = SecurityObservationSettings.withDefaults().shouldObserveRequests(true).shouldObserveAuthentications(true).shouldObserveAuthorizations(true).build();

    ObservationConfiguration() {
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<AuthorizationManager<HttpServletRequest>> webAuthorizationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<AuthorizationManager<HttpServletRequest>>(){

            @Override
            public AuthorizationManager postProcess(AuthorizationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthorizations();
                return active ? new ObservationAuthorizationManager(r, object) : object;
            }
        };
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<AuthenticationManager> authenticationManagerPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<AuthenticationManager>(){

            @Override
            public AuthenticationManager postProcess(AuthenticationManager object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveAuthentications();
                return active ? new ObservationAuthenticationManager(r, object) : object;
            }
        };
    }

    @Bean
    @Role(value=2)
    static ObjectPostProcessor<FilterChainProxy.FilterChainDecorator> filterChainDecoratorPostProcessor(final ObjectProvider<ObservationRegistry> registry, final ObjectProvider<SecurityObservationSettings> predicate) {
        return new ObjectPostProcessor<FilterChainProxy.FilterChainDecorator>(){

            @Override
            public FilterChainProxy.FilterChainDecorator postProcess(FilterChainProxy.FilterChainDecorator object) {
                ObservationRegistry r = (ObservationRegistry)registry.getIfUnique(() -> ObservationRegistry.NOOP);
                boolean active = !r.isNoop() && ((SecurityObservationSettings)predicate.getIfUnique(() -> all)).shouldObserveRequests();
                return active ? new ObservationFilterChainDecorator(r) : object;
            }
        };
    }
}

