/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;

public class ExceptionUtils {
    public static final String CONTACT_EMAIL = "DatabaseDevOps@red-gate.com";

    public static Throwable getRootCause(Throwable throwable) {
        Throwable rootCause;
        if (throwable == null) {
            return null;
        }
        Throwable cause = throwable;
        while ((rootCause = cause.getCause()) != null) {
            cause = rootCause;
        }
        return cause;
    }

    public static String getThrowLocation(Throwable e) {
        StackTraceElement element = e.getStackTrace()[0];
        int lineNumber = element.getLineNumber();
        return element.getClassName() + "." + element.getMethodName() + (String)(lineNumber < 0 ? "" : ":" + lineNumber) + (element.isNativeMethod() ? " [native]" : "");
    }

    public static String toMessage(SQLException e) {
        SQLException cause = e;
        while (cause.getNextException() != null) {
            cause = cause.getNextException();
        }
        String message = "SQL State  : " + cause.getSQLState() + "\nError Code : " + cause.getErrorCode() + "\n";
        if (cause.getMessage() != null) {
            message = message + "Message    : " + cause.getMessage().trim() + "\n";
        }
        return message;
    }

    public static Optional<String> getFlywayExceptionMessage(Throwable throwable) {
        for (Throwable exception = throwable.getCause(); exception != null; exception = exception.getCause()) {
            if (!(exception instanceof FlywayException)) continue;
            return Optional.of(exception.getMessage());
        }
        return Optional.empty();
    }

    public static boolean exceptionHasCauseOf(Throwable exception, Class<?> cause) {
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            if (!cause.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    @Generated
    private ExceptionUtils() {
    }
}

