/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PulsarClientException
extends IOException {
    private long sequenceId = -1L;
    private Collection<Throwable> previous;

    public PulsarClientException(String msg) {
        super(msg);
    }

    public PulsarClientException(String msg, long sequenceId) {
        super(msg);
        this.sequenceId = sequenceId;
    }

    public PulsarClientException(Throwable t) {
        super(t);
    }

    public PulsarClientException(String msg, Throwable t) {
        super(msg, t);
    }

    public void setPreviousExceptions(Collection<Throwable> previous) {
        this.previous = previous;
    }

    public Collection<Throwable> getPreviousExceptions() {
        return this.previous;
    }

    @Override
    public String toString() {
        if (this.previous == null || this.previous.isEmpty()) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder(super.toString());
        int i = 0;
        boolean first = true;
        sb.append("{\"previous\":[");
        for (Throwable t : this.previous) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("{\"attempt\":").append(i++).append(",\"error\":\"").append(t.toString().replace("\"", "\\\"")).append("\"}");
        }
        sb.append("]}");
        return sb.toString();
    }

    public PulsarClientException(Throwable t, long sequenceId) {
        super(t);
        this.sequenceId = sequenceId;
    }

    public static Throwable wrap(Throwable t, String msg) {
        msg = msg + "\n" + t.getMessage();
        if (t instanceof TimeoutException) {
            return new TimeoutException(msg);
        }
        if (t instanceof InvalidConfigurationException) {
            return new InvalidConfigurationException(msg);
        }
        if (t instanceof AuthenticationException) {
            return new AuthenticationException(msg);
        }
        if (t instanceof IncompatibleSchemaException) {
            return new IncompatibleSchemaException(msg);
        }
        if (t instanceof TooManyRequestsException) {
            return new TooManyRequestsException(msg);
        }
        if (t instanceof LookupException) {
            return new LookupException(msg);
        }
        if (t instanceof ConnectException) {
            return new ConnectException(msg);
        }
        if (t instanceof AlreadyClosedException) {
            return new AlreadyClosedException(msg);
        }
        if (t instanceof TopicTerminatedException) {
            return new TopicTerminatedException(msg);
        }
        if (t instanceof AuthorizationException) {
            return new AuthorizationException(msg);
        }
        if (t instanceof GettingAuthenticationDataException) {
            return new GettingAuthenticationDataException(msg);
        }
        if (t instanceof UnsupportedAuthenticationException) {
            return new UnsupportedAuthenticationException(msg);
        }
        if (t instanceof BrokerPersistenceException) {
            return new BrokerPersistenceException(msg);
        }
        if (t instanceof BrokerMetadataException) {
            return new BrokerMetadataException(msg);
        }
        if (t instanceof ProducerBusyException) {
            return new ProducerBusyException(msg);
        }
        if (t instanceof ConsumerBusyException) {
            return new ConsumerBusyException(msg);
        }
        if (t instanceof NotConnectedException) {
            return new NotConnectedException();
        }
        if (t instanceof InvalidMessageException) {
            return new InvalidMessageException(msg);
        }
        if (t instanceof InvalidTopicNameException) {
            return new InvalidTopicNameException(msg);
        }
        if (t instanceof NotSupportedException) {
            return new NotSupportedException(msg);
        }
        if (t instanceof NotAllowedException) {
            return new NotAllowedException(msg);
        }
        if (t instanceof ProducerQueueIsFullError) {
            return new ProducerQueueIsFullError(msg);
        }
        if (t instanceof ProducerBlockedQuotaExceededError) {
            return new ProducerBlockedQuotaExceededError(msg);
        }
        if (t instanceof ProducerBlockedQuotaExceededException) {
            return new ProducerBlockedQuotaExceededException(msg);
        }
        if (t instanceof ChecksumException) {
            return new ChecksumException(msg);
        }
        if (t instanceof CryptoException) {
            return new CryptoException(msg);
        }
        if (t instanceof ConsumerAssignException) {
            return new ConsumerAssignException(msg);
        }
        if (t instanceof MessageAcknowledgeException) {
            return new MessageAcknowledgeException(msg);
        }
        if (t instanceof TransactionConflictException) {
            return new TransactionConflictException(msg);
        }
        if (t instanceof TransactionHasOperationFailedException) {
            return new TransactionHasOperationFailedException(msg);
        }
        if (t instanceof PulsarClientException) {
            return new PulsarClientException(msg);
        }
        if (t instanceof CompletionException) {
            return t;
        }
        if (t instanceof RuntimeException) {
            return new RuntimeException(msg, t.getCause());
        }
        if (t instanceof InterruptedException) {
            return t;
        }
        if (t instanceof ExecutionException) {
            return t;
        }
        return t;
    }

    public static PulsarClientException unwrap(Throwable t) {
        if (t instanceof PulsarClientException) {
            return (PulsarClientException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof InterruptedException) {
            return new PulsarClientException(t);
        }
        if (!(t instanceof ExecutionException)) {
            return new PulsarClientException(t);
        }
        Throwable cause = t.getCause();
        String msg = cause.getMessage();
        PulsarClientException newException = cause instanceof TimeoutException ? new TimeoutException(msg) : (cause instanceof InvalidConfigurationException ? new InvalidConfigurationException(msg) : (cause instanceof AuthenticationException ? new AuthenticationException(msg) : (cause instanceof IncompatibleSchemaException ? new IncompatibleSchemaException(msg) : (cause instanceof TooManyRequestsException ? new TooManyRequestsException(msg) : (cause instanceof LookupException ? new LookupException(msg) : (cause instanceof ConnectException ? new ConnectException(msg) : (cause instanceof AlreadyClosedException ? new AlreadyClosedException(msg) : (cause instanceof TopicTerminatedException ? new TopicTerminatedException(msg) : (cause instanceof AuthorizationException ? new AuthorizationException(msg) : (cause instanceof GettingAuthenticationDataException ? new GettingAuthenticationDataException(msg) : (cause instanceof UnsupportedAuthenticationException ? new UnsupportedAuthenticationException(msg) : (cause instanceof BrokerPersistenceException ? new BrokerPersistenceException(msg) : (cause instanceof BrokerMetadataException ? new BrokerMetadataException(msg) : (cause instanceof ProducerBusyException ? new ProducerBusyException(msg) : (cause instanceof ConsumerBusyException ? new ConsumerBusyException(msg) : (cause instanceof NotConnectedException ? new NotConnectedException() : (cause instanceof InvalidMessageException ? new InvalidMessageException(msg) : (cause instanceof InvalidTopicNameException ? new InvalidTopicNameException(msg) : (cause instanceof NotSupportedException ? new NotSupportedException(msg) : (cause instanceof NotAllowedException ? new NotAllowedException(msg) : (cause instanceof ProducerQueueIsFullError ? new ProducerQueueIsFullError(msg) : (cause instanceof ProducerBlockedQuotaExceededError ? new ProducerBlockedQuotaExceededError(msg) : (cause instanceof ProducerBlockedQuotaExceededException ? new ProducerBlockedQuotaExceededException(msg) : (cause instanceof ChecksumException ? new ChecksumException(msg) : (cause instanceof CryptoException ? new CryptoException(msg) : (cause instanceof ConsumerAssignException ? new ConsumerAssignException(msg) : (cause instanceof MessageAcknowledgeException ? new MessageAcknowledgeException(msg) : (cause instanceof TransactionConflictException ? new TransactionConflictException(msg) : (cause instanceof TopicDoesNotExistException ? new TopicDoesNotExistException(msg) : (cause instanceof SubscriptionNotFoundException ? new SubscriptionNotFoundException(msg) : (cause instanceof ProducerFencedException ? new ProducerFencedException(msg) : (cause instanceof MemoryBufferIsFullError ? new MemoryBufferIsFullError(msg) : (cause instanceof NotFoundException ? new NotFoundException(msg) : (cause instanceof TransactionHasOperationFailedException ? new TransactionHasOperationFailedException(msg) : new PulsarClientException(t)))))))))))))))))))))))))))))))))));
        Collection<Throwable> previousExceptions = PulsarClientException.getPreviousExceptions(t);
        if (previousExceptions != null) {
            newException.setPreviousExceptions(previousExceptions);
        }
        return newException;
    }

    public static Collection<Throwable> getPreviousExceptions(Throwable t) {
        Throwable e = t;
        for (int maxDepth = 20; maxDepth > 0 && e != null; --maxDepth) {
            Collection<Throwable> previous;
            if (e instanceof PulsarClientException && (previous = ((PulsarClientException)e).getPreviousExceptions()) != null) {
                return previous;
            }
            e = t.getCause();
        }
        return null;
    }

    public static void setPreviousExceptions(Throwable t, Collection<Throwable> previous) {
        Throwable e = t;
        for (int maxDepth = 20; maxDepth > 0 && e != null; --maxDepth) {
            if (e instanceof PulsarClientException) {
                ((PulsarClientException)e).setPreviousExceptions(previous);
                return;
            }
            e = t.getCause();
        }
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public static boolean isRetriableError(Throwable t) {
        return !(t instanceof AuthorizationException) && !(t instanceof InvalidServiceURL) && !(t instanceof InvalidConfigurationException) && !(t instanceof NotFoundException) && !(t instanceof IncompatibleSchemaException) && !(t instanceof TopicDoesNotExistException) && !(t instanceof SubscriptionNotFoundException) && !(t instanceof UnsupportedAuthenticationException) && !(t instanceof InvalidMessageException) && !(t instanceof InvalidTopicNameException) && !(t instanceof NotSupportedException) && !(t instanceof NotAllowedException) && !(t instanceof ChecksumException) && !(t instanceof CryptoException) && !(t instanceof ConsumerAssignException) && !(t instanceof MessageAcknowledgeException) && !(t instanceof TransactionConflictException) && !(t instanceof ProducerBusyException) && !(t instanceof ConsumerBusyException) && !(t instanceof TransactionHasOperationFailedException);
    }

    public static class TimeoutException
    extends PulsarClientException {
        public TimeoutException(Throwable t) {
            super(t);
        }

        public TimeoutException(Throwable t, long sequenceId) {
            super(t, sequenceId);
        }

        public TimeoutException(String msg) {
            super(msg);
        }

        public TimeoutException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class InvalidConfigurationException
    extends PulsarClientException {
        public InvalidConfigurationException(String msg) {
            super(msg);
        }

        public InvalidConfigurationException(Throwable t) {
            super(t);
        }

        public InvalidConfigurationException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class AuthenticationException
    extends PulsarClientException {
        public AuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class IncompatibleSchemaException
    extends PulsarClientException {
        public IncompatibleSchemaException(Throwable t) {
            super(t);
        }

        public IncompatibleSchemaException(String msg) {
            super(msg);
        }
    }

    public static class TooManyRequestsException
    extends LookupException {
        public TooManyRequestsException(String msg) {
            super(msg);
        }
    }

    public static class LookupException
    extends PulsarClientException {
        public LookupException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarClientException {
        public ConnectException(Throwable t) {
            super(t);
        }

        public ConnectException(String msg) {
            super(msg);
        }
    }

    public static class AlreadyClosedException
    extends PulsarClientException {
        public AlreadyClosedException(String msg) {
            super(msg);
        }

        public AlreadyClosedException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class TopicTerminatedException
    extends PulsarClientException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }

        public TopicTerminatedException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class AuthorizationException
    extends PulsarClientException {
        public AuthorizationException(String msg) {
            super(msg);
        }
    }

    public static class GettingAuthenticationDataException
    extends PulsarClientException {
        public GettingAuthenticationDataException(Throwable t) {
            super(t);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedAuthenticationException
    extends PulsarClientException {
        public UnsupportedAuthenticationException(Throwable t) {
            super(t);
        }

        public UnsupportedAuthenticationException(String msg) {
            super(msg);
        }
    }

    public static class BrokerPersistenceException
    extends PulsarClientException {
        public BrokerPersistenceException(String msg) {
            super(msg);
        }
    }

    public static class BrokerMetadataException
    extends PulsarClientException {
        public BrokerMetadataException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBusyException
    extends PulsarClientException {
        public ProducerBusyException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerBusyException
    extends PulsarClientException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }
    }

    public static class NotConnectedException
    extends PulsarClientException {
        public NotConnectedException() {
            super("Not connected to broker");
        }

        public NotConnectedException(long sequenceId) {
            super("Not connected to broker", sequenceId);
        }

        public NotConnectedException(String msg) {
            super(msg);
        }
    }

    public static class InvalidMessageException
    extends PulsarClientException {
        public InvalidMessageException(String msg) {
            super(msg);
        }

        public InvalidMessageException(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class InvalidTopicNameException
    extends PulsarClientException {
        public InvalidTopicNameException(String msg) {
            super(msg);
        }
    }

    public static class NotSupportedException
    extends PulsarClientException {
        public NotSupportedException(String msg) {
            super(msg);
        }
    }

    public static class NotAllowedException
    extends PulsarClientException {
        public NotAllowedException(String msg) {
            super(msg);
        }
    }

    public static class ProducerQueueIsFullError
    extends PulsarClientException {
        public ProducerQueueIsFullError(String msg) {
            super(msg);
        }

        public ProducerQueueIsFullError(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class ProducerBlockedQuotaExceededError
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededError(String msg) {
            super(msg);
        }
    }

    public static class ProducerBlockedQuotaExceededException
    extends PulsarClientException {
        public ProducerBlockedQuotaExceededException(String msg) {
            super(msg);
        }
    }

    public static class ChecksumException
    extends PulsarClientException {
        public ChecksumException(String msg) {
            super(msg);
        }
    }

    public static class CryptoException
    extends PulsarClientException {
        public CryptoException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerAssignException
    extends PulsarClientException {
        public ConsumerAssignException(String msg) {
            super(msg);
        }
    }

    public static class MessageAcknowledgeException
    extends PulsarClientException {
        public MessageAcknowledgeException(Throwable t) {
            super(t);
        }

        public MessageAcknowledgeException(String msg) {
            super(msg);
        }
    }

    public static class TransactionConflictException
    extends PulsarClientException {
        public TransactionConflictException(Throwable t) {
            super(t);
        }

        public TransactionConflictException(String msg) {
            super(msg);
        }
    }

    public static class TransactionHasOperationFailedException
    extends PulsarClientException {
        public TransactionHasOperationFailedException() {
            super("Now allowed to commit the transaction due to failed operations of producing or acknowledgment");
        }

        public TransactionHasOperationFailedException(String msg) {
            super(msg);
        }
    }

    public static class TopicDoesNotExistException
    extends PulsarClientException {
        public TopicDoesNotExistException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionNotFoundException
    extends PulsarClientException {
        public SubscriptionNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class ProducerFencedException
    extends PulsarClientException {
        public ProducerFencedException(String msg) {
            super(msg);
        }
    }

    public static class MemoryBufferIsFullError
    extends PulsarClientException {
        public MemoryBufferIsFullError(String msg) {
            super(msg);
        }

        public MemoryBufferIsFullError(String msg, long sequenceId) {
            super(msg, sequenceId);
        }
    }

    public static class NotFoundException
    extends PulsarClientException {
        public NotFoundException(String msg) {
            super(msg);
        }

        public NotFoundException(Throwable t) {
            super(t);
        }
    }

    public static class InvalidServiceURL
    extends PulsarClientException {
        public InvalidServiceURL(Throwable t) {
            super(t);
        }

        public InvalidServiceURL(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static enum FailedFeatureCheck {
        SupportsGetPartitionedMetadataWithoutAutoCreation;

    }

    public static class FeatureNotSupportedException
    extends NotSupportedException {
        private final FailedFeatureCheck failedFeatureCheck;

        public FeatureNotSupportedException(String msg, FailedFeatureCheck failedFeatureCheck) {
            super(msg);
            this.failedFeatureCheck = failedFeatureCheck;
        }

        @Generated
        public FailedFeatureCheck getFailedFeatureCheck() {
            return this.failedFeatureCheck;
        }
    }

    public static class TopicMigrationException
    extends PulsarClientException {
        public TopicMigrationException(String msg) {
            super(msg);
        }
    }

    public static class ServiceNotReadyException
    extends LookupException {
        public ServiceNotReadyException(String msg) {
            super(msg);
        }
    }
}

