/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import java.util.List;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public class WithItem<T, R> {
    private String _name;
    private QueryExpression<T, R> _query;

    public WithItem(String name, List<String> aliases, QueryExpression<T, R> query) {
        this._name = name;
        this._query = query;
        if (aliases != null && !aliases.isEmpty()) {
            SetExpression<T, R> setExpression = this._query.getSelect();
            if (setExpression.getProjections().size() != aliases.size()) {
                throw QueryParsingException.of("Number of WITH clause column names does not match number of elements in select list", new Object[0]);
            }
            for (SelectExpression<T, R> select : setExpression.getSelections()) {
                List<ProjectionExpression<T, R>> projections = select.getProjections();
                for (int i = 0; i < aliases.size(); ++i) {
                    projections.get(i).setAlias(aliases.get(i));
                }
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public QueryExpression<T, R> getQuery() {
        return this._query;
    }

    public void setQuery(QueryExpression<T, R> query) {
        this._query = query;
    }
}

