/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import java.awt.Color;
import java.net.URI;
import java.util.Objects;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.style.se1.AnchorPoint;
import org.apache.sis.style.se1.ChannelSelection;
import org.apache.sis.style.se1.ColorMap;
import org.apache.sis.style.se1.ColorReplacement;
import org.apache.sis.style.se1.ContrastEnhancement;
import org.apache.sis.style.se1.Description;
import org.apache.sis.style.se1.Displacement;
import org.apache.sis.style.se1.ExternalGraphic;
import org.apache.sis.style.se1.Fill;
import org.apache.sis.style.se1.Font;
import org.apache.sis.style.se1.Graphic;
import org.apache.sis.style.se1.GraphicFill;
import org.apache.sis.style.se1.GraphicStroke;
import org.apache.sis.style.se1.Halo;
import org.apache.sis.style.se1.LegendGraphic;
import org.apache.sis.style.se1.LinePlacement;
import org.apache.sis.style.se1.LineSymbolizer;
import org.apache.sis.style.se1.Mark;
import org.apache.sis.style.se1.PointPlacement;
import org.apache.sis.style.se1.PointSymbolizer;
import org.apache.sis.style.se1.PolygonSymbolizer;
import org.apache.sis.style.se1.RasterSymbolizer;
import org.apache.sis.style.se1.Rule;
import org.apache.sis.style.se1.SelectedChannel;
import org.apache.sis.style.se1.ShadedRelief;
import org.apache.sis.style.se1.Stroke;
import org.apache.sis.style.se1.TextSymbolizer;

public class StyleFactory<R> {
    final DefaultFilterFactory<R, ?, ?> filterFactory;
    final Expression<R, Boolean> enabled;
    final Expression<R, Boolean> disabled;
    final Expression<R, Integer> zeroAsInt;
    final Expression<R, Double> zero;
    final Expression<R, Double> half;
    final Expression<R, Double> one;
    final Expression<R, Double> six;
    final Expression<R, Double> ten;
    final Expression<R, Double> relief;
    final Expression<R, String> normal;
    final Expression<R, String> square;
    final Expression<R, String> bevel;
    final Expression<R, Color> black;
    final Expression<R, Color> gray;
    final Expression<R, Color> white;
    final Expression<R, ?> defaultGeometry;

    public StyleFactory(DefaultFilterFactory<R, ?, ?> filterFactory) {
        this.filterFactory = Objects.requireNonNull(filterFactory);
        this.enabled = filterFactory.literal((Object)Boolean.TRUE);
        this.disabled = filterFactory.literal((Object)Boolean.FALSE);
        this.zeroAsInt = filterFactory.literal((Object)0);
        this.zero = filterFactory.literal((Object)0.0);
        this.half = filterFactory.literal((Object)0.5);
        this.one = filterFactory.literal((Object)1.0);
        this.six = filterFactory.literal((Object)6.0);
        this.ten = filterFactory.literal((Object)10.0);
        this.relief = filterFactory.literal((Object)55.0);
        this.normal = filterFactory.literal((Object)"normal");
        this.square = filterFactory.literal((Object)"square");
        this.bevel = filterFactory.literal((Object)"bevel");
        this.black = filterFactory.literal((Object)Color.BLACK);
        this.gray = filterFactory.literal((Object)Color.GRAY);
        this.white = filterFactory.literal((Object)Color.WHITE);
        this.defaultGeometry = filterFactory.property("sis:geometry");
    }

    StyleFactory(StyleFactory<?> source) {
        this.enabled = source.enabled;
        this.disabled = source.disabled;
        this.zeroAsInt = source.zeroAsInt;
        this.zero = source.zero;
        this.half = source.half;
        this.one = source.one;
        this.six = source.six;
        this.ten = source.ten;
        this.relief = source.relief;
        this.normal = source.normal;
        this.square = source.square;
        this.bevel = source.bevel;
        this.black = source.black;
        this.gray = source.gray;
        this.white = source.white;
        this.filterFactory = null;
        this.defaultGeometry = null;
    }

    public Rule<R> createRule() {
        return new Rule(this);
    }

    public PointSymbolizer<R> createPointSymbolizer() {
        return new PointSymbolizer(this);
    }

    public LineSymbolizer<R> createLineSymbolizer() {
        return new LineSymbolizer(this);
    }

    public PolygonSymbolizer<R> createPolygonSymbolizer() {
        return new PolygonSymbolizer(this);
    }

    public TextSymbolizer<R> createTextSymbolizer() {
        return new TextSymbolizer(this);
    }

    public TextSymbolizer<R> createTextSymbolizer(String label) {
        TextSymbolizer<R> s = this.createTextSymbolizer();
        s.label = s.literal(label);
        return s;
    }

    public RasterSymbolizer<R> createRasterSymbolizer() {
        return new RasterSymbolizer(this);
    }

    public Description<R> createDescription() {
        return new Description(this);
    }

    public PointPlacement<R> createPointPlacement() {
        return new PointPlacement(this);
    }

    public LinePlacement<R> createLinePlacement() {
        return new LinePlacement(this);
    }

    public AnchorPoint<R> createAnchorPoint() {
        return new AnchorPoint(this);
    }

    public AnchorPoint<R> createAnchorPoint(double x, double y) {
        AnchorPoint<R> s = this.createAnchorPoint();
        s.anchorPointX = this.filterFactory.literal((Object)x);
        s.anchorPointY = this.filterFactory.literal((Object)y);
        return s;
    }

    public Displacement<R> createDisplacement() {
        return new Displacement(this);
    }

    public Displacement<R> createDisplacement(double x, double y) {
        Displacement<R> s = this.createDisplacement();
        s.displacementX = this.filterFactory.literal((Object)x);
        s.displacementY = this.filterFactory.literal((Object)y);
        return s;
    }

    public Mark<R> createMark() {
        return new Mark(this);
    }

    public ExternalGraphic<R> createExternalGraphic() {
        return new ExternalGraphic(this);
    }

    public ExternalGraphic<R> createExternalGraphic(URI linkage, String format) {
        ExternalGraphic<R> s = this.createExternalGraphic();
        s.format = format;
        if (linkage != null) {
            s.onlineResource = new DefaultOnlineResource(linkage);
        }
        return s;
    }

    public Stroke<R> createStroke() {
        return new Stroke(this);
    }

    public Stroke<R> createStroke(Color color) {
        Stroke<R> s = this.createStroke();
        s.setColorAndOpacity(color);
        return s;
    }

    public Fill<R> createFill() {
        return new Fill(this);
    }

    public Fill<R> createFill(Color color) {
        Fill<R> s = this.createFill();
        s.setColorAndOpacity(color);
        return s;
    }

    public Halo<R> createHalo() {
        return new Halo(this);
    }

    public Font<R> createFont() {
        return new Font(this);
    }

    public Graphic<R> createGraphic() {
        return new Graphic(this);
    }

    public GraphicFill<R> createGraphicFill() {
        return new GraphicFill(this);
    }

    public GraphicStroke<R> createGraphicStroke() {
        return new GraphicStroke(this);
    }

    public LegendGraphic<R> createLegendGraphic() {
        return new LegendGraphic(this);
    }

    public ColorReplacement<R> createColorReplacement() {
        return new ColorReplacement(this);
    }

    public ColorMap<R> createColorMap() {
        return new ColorMap(this);
    }

    public ChannelSelection<R> createChannelSelection() {
        return new ChannelSelection(this);
    }

    public SelectedChannel<R> createSelectedChannel() {
        return new SelectedChannel(this);
    }

    public SelectedChannel<R> createSelectedChannel(String sourceChannelName) {
        SelectedChannel<R> s = this.createSelectedChannel();
        s.sourceChannelName = s.literal(sourceChannelName);
        return s;
    }

    public ContrastEnhancement<R> createContrastEnhancement() {
        return new ContrastEnhancement(this);
    }

    public ShadedRelief<R> createShadedRelief() {
        return new ShadedRelief(this);
    }
}

