/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectDescriptionManager {
    private static final String VALIDATION_BUILDER_NAME = "org.eclipse.wst.validation.validationbuilder";
    private final Logger logger;

    public ProjectDescriptionManager(Logger logger) {
        this.logger = logger;
    }

    public void enableValidationBuilderAndCommand(IProject project, IProgressMonitor monitor) throws CoreException {
        ICommand[] builders;
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = builders = description.getBuildSpec();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand builder = iCommandArray[n2];
            if (builder.getBuilderName().equals(VALIDATION_BUILDER_NAME)) {
                this.logger.trace("Validation builder already installed, skipping", new Object[0]);
                return;
            }
            ++n2;
        }
        this.logger.trace("Installing validation builder", new Object[0]);
        ICommand[] newBuilders = new ICommand[builders.length + 1];
        System.arraycopy(builders, 0, newBuilders, 0, builders.length);
        ICommand validationCommand = description.newCommand();
        validationCommand.setBuilderName(VALIDATION_BUILDER_NAME);
        newBuilders[newBuilders.length - 1] = validationCommand;
        description.setBuildSpec(newBuilders);
        project.setDescription(description, monitor);
        this.logger.trace("Installed validation builder", new Object[0]);
    }
}

