/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.NestedProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;

public class PropertyDescriptorProperty
implements Property {
    protected PropertyDescriptor descriptor;

    public PropertyDescriptorProperty(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        Type[] types;
        Method readMethod = this.descriptor.getReadMethod();
        Type[] typeArray = types = null != readMethod ? readMethod.getGenericParameterTypes() : null;
        if (null == types || types.length == 0) {
            return this.descriptor.getPropertyType();
        }
        Type parameterType = types[0];
        return LocalUtil.toClass(parameterType, this.toString());
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        try {
            return this.descriptor.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new ConversionException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        try {
            Method setter = LocalUtil.getWriteMethod(bean.getClass(), this.descriptor);
            setter.invoke(bean, value);
        }
        catch (InvocationTargetException ex) {
            throw new ConversionException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public Property createChild(int newParameterNumber) throws ConversionException {
        Method method = this.descriptor.getReadMethod();
        if (method == null) {
            throw new ConversionException(this.descriptor.getPropertyType(), "Property \"" + this.descriptor.getDisplayName() + "\" of type " + this.descriptor.getPropertyType().getName() + " has no read method (getter).");
        }
        return new NestedProperty(this, method, method.getGenericReturnType(), 0, newParameterNumber);
    }

    public int hashCode() {
        return this.descriptor.getReadMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescriptorProperty that = (PropertyDescriptorProperty)obj;
        return this.descriptor.getReadMethod().equals(that.descriptor.getReadMethod());
    }

    public String toString() {
        return "PropertyDescriptorProperty[" + this.descriptor.getName() + "=" + this.descriptor.getPropertyType() + "]";
    }
}

