/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;

class ComponentQueue {
    private static final int INITIAL = 8;
    private static final int ADDITIONAL = 8;
    private Component[] queue;
    private int queueSize = 0;
    private boolean dirty = false;
    private String[] seen;
    private int seenSize = 0;

    ComponentQueue() {
    }

    void add(Component ... components) {
        for (Component component : components) {
            this.add(component);
        }
    }

    void add(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (this.seen != null) {
            for (int i = 0; i < this.seenSize; ++i) {
                if (!this.seen[i].equals(component.getId())) continue;
                throw new WicketRuntimeException("A component with id: " + component.getId() + " has already been queued");
            }
        }
        if (this.dirty) {
            if (this.queueSize == 0) {
                this.queue = null;
            } else {
                Component[] replacement = new Component[this.queueSize + 8];
                int pos = 0;
                for (int i = 0; i < this.queue.length; ++i) {
                    if (this.queue[i] == null) continue;
                    replacement[pos++] = this.queue[i];
                }
                this.queue = replacement;
            }
        }
        if (this.queue == null) {
            this.queue = new Component[8];
        } else if (this.queue.length == this.queueSize) {
            this.queue = Arrays.copyOf(this.queue, this.queue.length + 8);
        }
        this.queue[this.queueSize] = component;
        ++this.queueSize;
        if (this.seen == null) {
            this.seen = new String[8];
        } else if (this.seenSize == this.seen.length) {
            this.seen = Arrays.copyOf(this.seen, this.seen.length + 8);
        }
        this.seen[this.seenSize] = component.getId();
        ++this.seenSize;
    }

    Component remove(String id) {
        int seen = 0;
        for (int i = 0; i < this.queue.length && seen < this.queueSize; ++i) {
            Component component = this.queue[i];
            if (component == null) continue;
            ++seen;
            if (!component.getId().equals(id)) continue;
            this.queue[i] = null;
            this.dirty = true;
            --this.queueSize;
            return component;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.queueSize == 0;
    }

    public Component get(String id) {
        for (Component component : this.queue) {
            if (component == null || !component.getId().equals(id)) continue;
            return component;
        }
        return null;
    }

    public String toString() {
        return "ComponentQueue{queueSize=" + this.queueSize + ", queue=" + Arrays.toString(this.queue) + "}";
    }
}

