/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.jms.reply.CorrelationTimeoutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSelectorCreator {
    protected static final Logger LOG = LoggerFactory.getLogger(MessageSelectorCreator.class);
    protected final TimeoutMap<String, ?> timeoutMap;
    protected final ConcurrentSkipListSet<String> correlationIds;
    protected volatile boolean dirty = true;
    protected StringBuilder expression;
    private final Lock lock = new ReentrantLock();

    public MessageSelectorCreator(CorrelationTimeoutMap timeoutMap) {
        this.timeoutMap = timeoutMap;
        this.timeoutMap.addListener((type, cid, value) -> this.timeoutEvent(type, (String)cid));
        this.correlationIds = new ConcurrentSkipListSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        this.lock.lock();
        try {
            if (!this.dirty) {
                String string = this.expression.toString();
                return string;
            }
            this.expression = new StringBuilder(256);
            this.expression.append("JMSCorrelationID='");
            if (this.correlationIds.isEmpty()) {
                this.expression.append("CamelDummyJmsMessageSelector'");
            } else {
                boolean first = true;
                for (String value : this.correlationIds) {
                    if (!first) {
                        this.expression.append(" OR JMSCorrelationID='");
                    }
                    this.expression.append(value).append("'");
                    if (!first) continue;
                    first = false;
                }
            }
            String answer = this.expression.toString();
            this.dirty = false;
            String string = answer;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void timeoutEvent(TimeoutMap.Listener.Type type, String cid) {
        this.lock.lock();
        try {
            if (type == TimeoutMap.Listener.Type.Put) {
                this.correlationIds.add(cid);
            } else if (type == TimeoutMap.Listener.Type.Remove || type == TimeoutMap.Listener.Type.Evict) {
                this.correlationIds.remove(cid);
            }
            this.dirty = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

