/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class XAttr {
    private final NameSpace ns;
    private final String name;
    private final byte[] value;

    private XAttr(NameSpace ns, String name, byte[] value) {
        this.ns = ns;
        this.name = name;
        this.value = value;
    }

    public NameSpace getNameSpace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        return new HashCodeBuilder(811, 67).append(this.name).append((Object)this.ns).append(this.value).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        XAttr rhs = (XAttr)obj;
        return new EqualsBuilder().append((Object)this.ns, (Object)rhs.ns).append(this.name, rhs.name).append(this.value, rhs.value).isEquals();
    }

    public boolean equalsIgnoreValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        XAttr rhs = (XAttr)obj;
        return new EqualsBuilder().append((Object)this.ns, (Object)rhs.ns).append(this.name, rhs.name).isEquals();
    }

    public String toString() {
        return "XAttr [ns=" + (Object)((Object)this.ns) + ", name=" + this.name + ", value=" + Arrays.toString(this.value) + "]";
    }

    public static class Builder {
        private NameSpace ns = NameSpace.USER;
        private String name;
        private byte[] value;

        public Builder setNameSpace(NameSpace ns) {
            this.ns = ns;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setValue(byte[] value) {
            this.value = value;
            return this;
        }

        public XAttr build() {
            return new XAttr(this.ns, this.name, this.value);
        }
    }

    public static enum NameSpace {
        USER,
        TRUSTED,
        SECURITY,
        SYSTEM,
        RAW;

    }
}

