/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.test.framework.TestHttpCall;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpCallImpl
extends TargetableTestComponentImpl
implements TestHttpCall {
    private static final Logger LOG = LoggerFactory.getLogger(TestHttpCallImpl.class);

    public void start(Collection<? extends Location> locations) {
        String url = null;
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            url = (String)this.getRequiredConfig(TARGET_URL);
            TestHttpCall.HttpMethod method = (TestHttpCall.HttpMethod)((Object)this.getRequiredConfig(TARGET_METHOD));
            Map headers = (Map)this.config().get(TARGET_HEADERS);
            String body = (String)this.config().get(TARGET_BODY);
            List<Map<String, Object>> assertions = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERTIONS);
            Duration timeout = (Duration)this.getConfig(TIMEOUT);
            Integer maxAttempts = (Integer)this.getConfig(MAX_ATTEMPTS);
            Duration backoffToPeriod = (Duration)this.getConfig(BACKOFF_TO_PERIOD);
            TestHttpCall.HttpAssertionTarget target = (TestHttpCall.HttpAssertionTarget)((Object)this.getRequiredConfig(ASSERTION_TARGET));
            boolean trustAll = (Boolean)this.getRequiredConfig(TRUST_ALL);
            if (!this.getChildren().isEmpty()) {
                throw new RuntimeException(String.format("The entity [%s] cannot have child entities", this.getClass().getName()));
            }
            this.doRequestAndCheckAssertions((Map<String, ?>)MutableMap.of((Object)"timeout", (Object)timeout, (Object)"backoffToPeriod", (Object)backoffToPeriod, (Object)"maxAttempts", (Object)maxAttempts), assertions, target, method, url, headers, trustAll, body);
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            if (url != null) {
                LOG.info("{} Url [{}] test failed (rethrowing)", (Object)this, (Object)url);
            } else {
                LOG.info("{} Url test failed (no url; rethrowing)", (Object)this);
            }
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void doRequestAndCheckAssertions(Map<String, ?> flags, List<Map<String, Object>> assertions, TestHttpCall.HttpAssertionTarget target, final TestHttpCall.HttpMethod method, final String url, final Map<String, String> headers, final boolean trustAll, final String body) {
        switch (target) {
            case body: {
                Supplier<String> getBody = new Supplier<String>(){

                    public String get() {
                        try {
                            HttpRequestBase httpMethod = TestHttpCallImpl.this.createHttpMethod(method, url, headers, body);
                            return HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().uri(url).trustAll(trustAll).build(), (HttpUriRequest)httpMethod).getContentAsString();
                        }
                        catch (Exception e) {
                            LOG.info("HTTP call to [{}] failed due to [{}]", (Object)url, (Object)e.getMessage());
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                };
                TestFrameworkAssertions.checkAssertionsEventually(new TestFrameworkAssertions.AssertionOptions(target.toString(), getBody).flags(flags).assertions(assertions));
                break;
            }
            case status: {
                Supplier<Integer> getStatusCode = new Supplier<Integer>(){

                    public Integer get() {
                        try {
                            HttpRequestBase httpMethod = TestHttpCallImpl.this.createHttpMethod(method, url, headers, body);
                            Maybe response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().uri(url).trustAll(trustAll).build(), (HttpUriRequest)httpMethod).getResponse();
                            if (response.isPresentAndNonNull()) {
                                return ((HttpResponse)response.get()).getStatusLine().getStatusCode();
                            }
                            throw new Exception("HTTP call did not return any response");
                        }
                        catch (Exception e) {
                            LOG.info("HTTP call to [{}] failed due to [{}]", (Object)url, (Object)e.getMessage());
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                };
                TestFrameworkAssertions.checkAssertionsEventually(new TestFrameworkAssertions.AssertionOptions(target.toString(), getStatusCode).flags(flags).assertions(assertions));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected assertion target (" + (Object)((Object)target) + ")");
            }
        }
    }

    private HttpRequestBase createHttpMethod(TestHttpCall.HttpMethod method, String url, Map<String, String> headers, String body) throws Exception {
        return new HttpTool.HttpRequestBuilder(method.requestClass).uri(new URI(url)).body(body).headers(headers).build();
    }

    public void stop() {
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }
}

