/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.jclouds.domain.Credentials;

public class GoogleCredentialsFromJson
implements Supplier<Credentials> {
    private final String jsonKeyString;

    public GoogleCredentialsFromJson(String jsonString) {
        Preconditions.checkNotNull((Object)jsonString, (Object)"Google Credentials jsonString cannot be null");
        this.jsonKeyString = jsonString;
    }

    private static Credentials parseJsonKeyString(String jsonString) {
        JsonObject json = new JsonParser().parse(jsonString).getAsJsonObject();
        String client_email = json.get("client_email").toString().replace("\"", "");
        String private_key = json.get("private_key").toString().replace("\"", "").replace("\\n", "\n");
        return new Credentials(client_email, private_key);
    }

    public Credentials get() {
        return GoogleCredentialsFromJson.parseJsonKeyString(this.jsonKeyString);
    }
}

