/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.rop.HttpClientConnection;
import org.apache.cayenne.rop.ROPConnector;
import org.apache.cayenne.rop.ROPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpROPConnector
implements ROPConnector {
    private static final Logger logger = LoggerFactory.getLogger(HttpROPConnector.class);
    public static final String SESSION_COOKIE_NAME = "JSESSIONID";
    private HttpClientConnection clientConnection;
    private String url;
    private String username;
    private String password;
    private Long readTimeout;

    public HttpROPConnector(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public void setClientConnection(HttpClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public InputStream establishSession() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info(ROPUtil.getLogConnect(this.url, this.username, this.password != null));
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("operation", "establish_session");
        return this.doRequest(requestParams);
    }

    @Override
    public InputStream establishSharedSession(String sharedSessionName) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info(ROPUtil.getLogConnect(this.url, this.username, this.password != null, sharedSessionName));
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("operation", "establish_shared_session");
        requestParams.put("session_name", sharedSessionName);
        return this.doRequest(requestParams);
    }

    @Override
    public InputStream sendMessage(byte[] message) throws IOException {
        return this.doRequest(message);
    }

    @Override
    public void close() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info(ROPUtil.getLogDisconnect(this.url, this.username, this.password != null));
        }
    }

    protected InputStream doRequest(Map<String, String> params) throws IOException {
        URLConnection connection = new URL(this.url).openConnection();
        if (this.readTimeout != null) {
            connection.setReadTimeout(this.readTimeout.intValue());
        }
        this.addAuthHeader(connection);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("charset", "utf-8");
        try (OutputStream output = connection.getOutputStream();){
            output.write(ROPUtil.getParamsAsString(params).getBytes(StandardCharsets.UTF_8));
            output.flush();
        }
        return connection.getInputStream();
    }

    protected InputStream doRequest(byte[] data) throws IOException {
        URLConnection connection = new URL(this.url).openConnection();
        if (this.readTimeout != null) {
            connection.setReadTimeout(this.readTimeout.intValue());
        }
        this.addAuthHeader(connection);
        this.addSessionCookie(connection);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        if (data != null) {
            try (OutputStream output = connection.getOutputStream();){
                output.write(data);
                output.flush();
            }
        }
        return connection.getInputStream();
    }

    protected void addAuthHeader(URLConnection connection) {
        String basicAuth = ROPUtil.getBasicAuth(this.username, this.password);
        if (basicAuth != null) {
            connection.addRequestProperty("Authorization", basicAuth);
        }
    }

    protected void addSessionCookie(URLConnection connection) {
        RemoteSession session = this.clientConnection.getSession();
        if (session != null && session.getSessionId() != null) {
            connection.addRequestProperty("Cookie", "JSESSIONID=" + session.getSessionId());
        }
    }
}

