/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;
import org.apache.cayenne.util.Util;

public abstract class CayenneAction
extends AbstractAction {
    protected boolean alwaysOn;
    protected Application application;

    public CayenneAction(String name, Application application) {
        this(name, application, name);
    }

    public CayenneAction(String name, Application application, String shortDescription) {
        super(name);
        KeyStroke accelerator;
        super.putValue("Default", name);
        this.application = application;
        Icon icon = this.createIcon();
        if (icon != null) {
            super.putValue("SmallIcon", icon);
        }
        if ((accelerator = this.getAcceleratorKey()) != null) {
            super.putValue("AcceleratorKey", accelerator);
        }
        if (shortDescription != null && shortDescription.length() > 0) {
            super.putValue("ShortDescription", shortDescription);
        }
        this.setEnabled(false);
    }

    public Application getApplication() {
        return this.application;
    }

    protected Project getCurrentProject() {
        return this.application.getFrameController().getProjectController().getProject();
    }

    public void setName(String newName) {
        if (!Util.nullSafeEquals(this.getValue("Name"), newName)) {
            super.putValue("Name", newName);
        }
    }

    public KeyStroke getAcceleratorKey() {
        return null;
    }

    public String getIconName() {
        return null;
    }

    public Icon createIcon() {
        String name = this.getIconName();
        return name != null ? ModelerUtil.buildIcon(name) : null;
    }

    public String getKey() {
        return (String)super.getValue("Default");
    }

    public abstract void performAction(ActionEvent var1);

    public boolean enableForPath(ConfigurationNode object) {
        return false;
    }

    public ProjectController getProjectController() {
        return this.application.getFrameController().getProjectController();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.performAction(e);
        }
        catch (Throwable th) {
            ErrorDebugDialog.guiException(th);
        }
    }

    public JMenuItem buildMenu() {
        return new CayenneMenuItem(this);
    }

    public JCheckBoxMenuItem buildCheckBoxMenu() {
        return new JCheckBoxMenuItem(this);
    }

    public JButton buildButton() {
        return new CayenneToolbarButton(this, 0);
    }

    public JButton buildButton(int position) {
        return new CayenneToolbarButton(this, position);
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    public void setAlwaysOn(boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
        if (alwaysOn) {
            super.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (!this.isAlwaysOn()) {
            super.setEnabled(b);
        }
    }

    protected static EditorView editor() {
        return ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
    }

    protected static TreePath buildTreePath(Entity entity) {
        DataChannelDescriptor domain = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        Object[] path = new Object[]{domain, entity.getDataMap(), entity};
        Object[] mutableTreeNodes = new Object[path.length];
        mutableTreeNodes[0] = ((ProjectTreeModel)CayenneAction.editor().getProjectTreeView().getModel()).getRootNode();
        for (int i = 1; i < path.length; ++i) {
            Object[] helper = new Object[i];
            int j = 0;
            while (j < i) {
                helper[j++] = path[j];
            }
            mutableTreeNodes[i] = ((ProjectTreeModel)CayenneAction.editor().getProjectTreeView().getModel()).getNodeForObjectPath(helper);
        }
        return new TreePath(mutableTreeNodes);
    }

    public static class CayenneMenuItem
    extends JMenuItem {
        public CayenneMenuItem(String title) {
            super(title);
        }

        public CayenneMenuItem(String title, Icon icon) {
            super(title, icon);
        }

        public CayenneMenuItem(AbstractAction action) {
            super(action);
        }
    }

    public static final class CayenneToolbarButton
    extends JButton {
        private static final String[] POSITIONS = new String[]{"only", "first", "middle", "last"};
        protected boolean showingText;

        public CayenneToolbarButton(Action a, int position) {
            this.setAction(a);
            this.initView(position);
        }

        private void initView(int position) {
            this.setDisabledIcon(FilteredIconFactory.createDisabledIcon(this.getIcon()));
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.putClientProperty("JButton.segmentPosition", POSITIONS[position]);
        }

        public boolean isShowingText() {
            return this.showingText;
        }

        public void setShowingText(boolean showingText) {
            this.showingText = showingText;
        }

        @Override
        public String getText() {
            return this.showingText ? super.getText() : null;
        }

        @Override
        public void setText(String text) {
            if (this.showingText) {
                super.setText(text);
            } else {
                super.setToolTipText(text);
            }
        }
    }
}

