/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

public class CircularArray<T> {
    private Object[] array = null;
    private int head = 0;
    private int tail = 0;
    private int count = 0;
    private int capacity = 0;

    public CircularArray(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero");
        }
        this.array = new Object[capacity];
        this.capacity = capacity;
    }

    public void clear() {
        this.array = new Object[this.capacity];
        this.head = 0;
        this.tail = 0;
        this.count = 0;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void add(Object obj) {
        if (this.count == this.capacity && this.tail == this.head) {
            this.head = (this.head + 1) % this.capacity;
        }
        this.array[this.tail] = obj;
        this.tail = (this.tail + 1) % this.capacity;
        ++this.count;
        if (this.count > this.capacity) {
            this.count = this.capacity;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    int convert(int index) {
        return (index + this.head) % this.capacity;
    }

    private void rangeCheck(int index) {
        if (index >= this.capacity || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.capacity);
        }
    }

    public boolean contains(T obj) {
        return this.indexOf(obj) >= 0;
    }

    public T get(int index) {
        this.rangeCheck(index);
        if (this.count == 0) {
            return null;
        }
        return (T)this.array[this.convert(index)];
    }

    public int indexOf(T obj) {
        for (int i = 0; i < this.capacity; ++i) {
            int index = this.convert(i);
            if (this.array[index] != obj) continue;
            return i;
        }
        return -1;
    }

    public void remove(T obj) {
        if (this.count == 0) {
            return;
        }
        int i = this.indexOf(obj);
        while (i >= 0) {
            int pos = this.convert(i);
            if (pos == this.head) {
                this.head = (this.head + 1) % this.capacity;
                this.array[pos] = null;
                --this.count;
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.capacity) % this.capacity;
                this.array[pos] = null;
                --this.count;
            } else {
                Object[] a = new Object[this.capacity];
                int destPos = 0;
                int len = 0;
                if (this.head == this.tail) {
                    if (this.head < pos) {
                        len = pos - this.head;
                        System.arraycopy(this.array, this.head, a, destPos, len);
                        destPos += len;
                        len = this.capacity - 1 - pos;
                        if (len > 0) {
                            System.arraycopy(this.array, pos + 1, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = this.head) > 0) {
                            System.arraycopy(this.array, 0, a, destPos, len);
                        }
                    } else if (this.head > pos) {
                        len = this.capacity - this.head;
                        if (len > 0) {
                            System.arraycopy(this.array, this.head, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = pos) > 0) {
                            System.arraycopy(this.array, 0, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = this.tail - pos - 1) > 0) {
                            System.arraycopy(this.array, pos + 1, a, destPos, len);
                        }
                    }
                } else if (this.head < this.tail) {
                    len = pos - this.head;
                    if (len > 0) {
                        System.arraycopy(this.array, this.head, a, destPos, len);
                        destPos += len;
                    }
                    if ((len = this.tail - pos) > 0) {
                        System.arraycopy(this.array, pos + 1, a, destPos, len);
                        destPos += len;
                    }
                } else if (this.head > this.tail) {
                    if (this.head < pos) {
                        len = pos - this.head;
                        System.arraycopy(this.array, this.head, a, destPos, len);
                        destPos += len;
                        len = this.capacity - 1 - pos;
                        if (len > 0) {
                            System.arraycopy(this.array, pos + 1, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = this.tail) > 0) {
                            System.arraycopy(this.array, 0, a, destPos, len);
                        }
                    } else if (this.head > pos) {
                        len = this.capacity - this.head;
                        if (len > 0) {
                            System.arraycopy(this.array, this.head, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = pos - 1) > 0) {
                            System.arraycopy(this.array, 0, a, destPos, len);
                            destPos += len;
                        }
                        if ((len = this.tail - pos) > 0) {
                            System.arraycopy(this.array, pos + 1, a, destPos, len);
                        }
                    }
                }
                this.array = a;
                this.head = 0;
                this.tail = --this.count;
            }
            i = this.indexOf(obj);
        }
    }

    public void resize(int newCapacity) {
        int i = 0;
        int offset = 0;
        if (newCapacity < this.count) {
            i = this.count - newCapacity;
            offset = this.count - newCapacity;
        }
        Object[] newArray = new Object[newCapacity];
        while (i < this.count) {
            newArray[i - offset] = this.array[this.convert(i)];
            ++i;
        }
        this.head = 0;
        this.tail = 0;
        this.capacity = newCapacity;
        if (this.capacity < this.count) {
            this.count = this.capacity;
        }
        this.array = newArray;
    }

    public int size() {
        return this.count;
    }

    public T[] toArray() {
        Object[] o = new Object[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            o[i] = this.array[this.convert(i)];
        }
        return o;
    }

    public String internalRep() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int i = 0; i < this.array.length; ++i) {
            sb.append('(').append(i).append(")  ");
            Object o = this.array[i];
            if (o == null) {
                sb.append("null");
            } else {
                sb.append(o.toString());
            }
            if (i == this.head || i == this.tail) {
                sb.append('<');
                if (i == this.head) {
                    sb.append("h");
                }
                if (i == this.tail) {
                    sb.append("t");
                }
            }
            sb.append("\n");
        }
        sb.append("count = [");
        sb.append(this.count);
        sb.append("]");
        sb.append("\nhead  = [");
        sb.append(this.head);
        sb.append("]");
        sb.append("\ntail  = [");
        sb.append(this.tail);
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        T[] oa = this.toArray();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < oa.length; ++i) {
            T o = oa[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (o == null) {
                sb.append("null");
                continue;
            }
            sb.append(o.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

