/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.example;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.help.FilterHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class XhtmlHelpAppendable
extends FilterHelpAppendable {
    public XhtmlHelpAppendable(Appendable output) {
        super(output);
    }

    public void appendHeader(int level, CharSequence text) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            if (level < 1) {
                throw new IllegalArgumentException("level must be at least 1");
            }
            this.appendFormat("<h%s>%s</h%1$s>%n", new Object[]{level, StringEscapeUtils.escapeHtml4((String)Objects.toString(text))});
        }
    }

    public void appendList(boolean ordered, Collection<CharSequence> list) throws IOException {
        if (list != null) {
            this.appendFormat("<%sl>%n", new Object[]{ordered ? "o" : "u"});
            for (CharSequence line : list) {
                this.appendFormat("  <li>%s</li>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)StringUtils.defaultIfEmpty((CharSequence)line, (CharSequence)"").toString())});
            }
            this.appendFormat("</%sl>%n", new Object[]{ordered ? "o" : "u"});
        }
    }

    public void appendParagraph(CharSequence paragraph) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)paragraph)) {
            this.appendFormat("<p>%s</p>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)Objects.toString(paragraph))});
        }
    }

    public void appendTable(TableDefinition table) throws IOException {
        if (table != null) {
            this.appendFormat("<table class='commons_cli_table'>%n", new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)table.caption())) {
                this.appendFormat("  <caption>%s</caption>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)table.caption())});
            }
            if (!table.headers().isEmpty()) {
                this.appendFormat("  <tr>%n", new Object[0]);
                for (String header : table.headers()) {
                    this.appendFormat("    <th>%s</th>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)header)});
                }
                this.appendFormat("  </tr>%n", new Object[0]);
            }
            for (List row : table.rows()) {
                this.appendFormat("  <tr>%n", new Object[0]);
                for (String column : row) {
                    this.appendFormat("    <td>%s</td>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)column)});
                }
                this.appendFormat("  </tr>%n", new Object[0]);
            }
            this.appendFormat("</table>%n", new Object[0]);
        }
    }

    public void appendTitle(CharSequence title) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            this.appendFormat("<span class='commons_cli_title'>%s</span>%n", new Object[]{StringEscapeUtils.escapeHtml4((String)Objects.toString(title))});
        }
    }
}

