/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.VFSFileSystem;
import org.apache.commons.configuration2.reloading.VFSFileHandlerReloadingDetector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestVFSFileHandlerReloadingDetector {
    private static final String PROPERTY = "string";
    private static final String FMT_XML = "<configuration><string>%s</string></configuration>";
    @TempDir
    public File tempFolder;

    @Test
    void testGetRefreshDelay() throws Exception {
        long delay = 20130325L;
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(null, 20130325L);
        Assertions.assertNotNull((Object)strategy.getFileHandler());
        Assertions.assertEquals((long)20130325L, (long)strategy.getRefreshDelay());
    }

    @Test
    void testLastModificationDateExisting() throws IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        this.writeTestFile(file, "value1");
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector();
        strategy.getFileHandler().setFile(file);
        strategy.getFileHandler().setFileSystem((FileSystem)new VFSFileSystem());
        long modificationDate = strategy.getLastModificationDate();
        long expectedMillis = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        Assertions.assertEquals((long)expectedMillis, (long)modificationDate);
    }

    @Test
    void testLastModificationDateFileSystemEx() throws FileSystemException {
        final FileObject fo = (FileObject)Mockito.mock(FileObject.class);
        FileName name = (FileName)Mockito.mock(FileName.class);
        Mockito.when((Object)fo.exists()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)fo.getContent()).thenThrow(new Throwable[]{new FileSystemException("error")});
        Mockito.when((Object)fo.getName()).thenReturn((Object)name);
        Mockito.when((Object)name.getURI()).thenReturn((Object)"someURI");
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(){

            protected FileObject getFileObject() {
                return fo;
            }
        };
        Assertions.assertEquals((long)0L, (long)strategy.getLastModificationDate());
        ((FileObject)Mockito.verify((Object)fo)).exists();
        ((FileObject)Mockito.verify((Object)fo)).getContent();
        ((FileObject)Mockito.verify((Object)fo)).getName();
        ((FileName)Mockito.verify((Object)name)).getURI();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fo, name});
    }

    @Test
    void testLastModificationDateNonExisting() {
        File file = ConfigurationAssert.getOutFile("NonExistingFile.xml");
        FileHandler handler = new FileHandler();
        handler.setFileSystem((FileSystem)new VFSFileSystem());
        handler.setFile(file);
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(handler);
        Assertions.assertEquals((long)0L, (long)strategy.getLastModificationDate());
    }

    @Test
    void testLastModificationDateUndefinedHandler() {
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector();
        Assertions.assertEquals((long)0L, (long)strategy.getLastModificationDate());
    }

    @Test
    void testLastModificationDateUnresolvableURI() {
        VFSFileHandlerReloadingDetector strategy = new VFSFileHandlerReloadingDetector(){

            protected String resolveFileURI() {
                return null;
            }
        };
        strategy.getFileHandler().setFileSystem((FileSystem)new VFSFileSystem());
        strategy.getFileHandler().setFileName("test.xml");
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ((VFSFileHandlerReloadingDetector)strategy).getLastModificationDate());
    }

    private void writeTestFile(File file, String value) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            out.write(String.format(FMT_XML, value));
        }
    }
}

