/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.apache.activemq.artemis.utils.SocketAddressUtil;

public class ProxyProtocolUtil {
    public static final AttributeKey<String> PROXY_PROTOCOL_SOURCE_ADDRESS = AttributeKey.valueOf((String)"proxyProtocolSourceAddress");
    public static final AttributeKey<String> PROXY_PROTOCOL_DESTINATION_ADDRESS = AttributeKey.valueOf((String)"proxyProtocolDestinationAddress");
    public static final AttributeKey<String> PROXY_PROTOCOL_VERSION = AttributeKey.valueOf((String)"proxyProtocolVersion");

    public static String getRemoteAddress(Channel channel) {
        String addressFromAttribute = ProxyProtocolUtil.getAddressFromAttribute(PROXY_PROTOCOL_SOURCE_ADDRESS, channel);
        if (addressFromAttribute != null) {
            return addressFromAttribute;
        }
        return SocketAddressUtil.toString(channel.remoteAddress());
    }

    public static String getProxyAddress(Channel channel) {
        return ProxyProtocolUtil.getAddressFromAttribute(PROXY_PROTOCOL_DESTINATION_ADDRESS, channel);
    }

    private static String getAddressFromAttribute(AttributeKey<String> addressKey, Channel channel) {
        String address = (String)channel.attr(addressKey).get();
        if (address != null && !address.isEmpty()) {
            return address;
        }
        return null;
    }

    public static String getProxyProtocolVersion(Channel channel) {
        return channel.attr(PROXY_PROTOCOL_VERSION).get() == null ? null : ((String)channel.attr(PROXY_PROTOCOL_VERSION).get()).toString();
    }
}

