/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.ProcInstr;
import scala.xml.TopScope$;

public class PrettyPrinter {
    private final int step;
    private final scala.collection.immutable.Seq<Node> mtChild;

    public PrettyPrinter(int step) {
        this.step = step;
        this.mtChild = new Elem(null, "foo", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])).child();
    }

    private boolean isLeaf(Node l) {
        Node node = l;
        return node instanceof Atom || node instanceof Comment || node instanceof EntityRef || node instanceof ProcInstr;
        {
        }
    }

    private boolean allAreLeaves(scala.collection.immutable.Seq<Node> ns) {
        return ns.forall((Function1 & Serializable)l -> this.isLeaf((Node)l));
    }

    public void format(Node n, StringBuilder sb) {
        Node c = this.minimizeScopes(n);
        this.format(c, sb, 0);
    }

    private Node minimizeScopes(Node n) {
        return this.minimizeScopes1(n, (scala.collection.immutable.Seq<NamespaceBinding>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)TopScope$.MODULE$, (List)Nil$.MODULE$))));
    }

    private scala.collection.immutable.Seq<NamespaceBinding> scopeToList(NamespaceBinding nb) {
        if (nb == TopScope$.MODULE$) {
            return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)TopScope$.MODULE$, (List)Nil$.MODULE$));
        }
        return (scala.collection.immutable.Seq)this.scopeToList(nb.parent()).$plus$colon((Object)nb);
    }

    private NamespaceBinding listToScope(scala.collection.immutable.Seq<NamespaceBinding> nbs) {
        if (nbs.isEmpty()) {
            return TopScope$.MODULE$;
        }
        NamespaceBinding nb = (NamespaceBinding)nbs.head();
        scala.collection.immutable.Seq rest = (scala.collection.immutable.Seq)nbs.tail();
        return new NamespaceBinding(nb.prefix(), nb.uri(), this.listToScope((scala.collection.immutable.Seq<NamespaceBinding>)rest));
    }

    private Node minimizeScopes1(Node n, scala.collection.immutable.Seq<NamespaceBinding> nbs) {
        Node node = n;
        if (node instanceof Elem) {
            Elem e = (Elem)node;
            scala.collection.immutable.Seq<NamespaceBinding> nScopeList = this.scopeToList(e.scope());
            scala.collection.immutable.Seq newNScopeList = (scala.collection.immutable.Seq)nScopeList.filter((Function1 & Serializable)x -> !nbs.exists((Function1 & Serializable)nb -> {
                String string = nb.prefix();
                String string2 = x.prefix();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = nb.uri();
                String string4 = x.uri();
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }));
            NamespaceBinding newNScope = this.listToScope((scala.collection.immutable.Seq<NamespaceBinding>)newNScopeList);
            scala.collection.immutable.Seq combinedNScopeList = (scala.collection.immutable.Seq)newNScopeList.$plus$plus(nbs);
            scala.collection.immutable.Seq minimizedChildren = (scala.collection.immutable.Seq)e.child().map((Function1 & Serializable)_$1 -> this.minimizeScopes1((Node)_$1, (scala.collection.immutable.Seq<NamespaceBinding>)combinedNScopeList));
            Elem newNode = e.copy(e.copy$default$1(), e.copy$default$2(), e.copy$default$3(), newNScope, e.copy$default$5(), (Seq)minimizedChildren);
            return newNode;
        }
        Node x2 = node;
        return x2;
    }

    private void format(Node n, StringBuilder sb, int cur) {
        Node node = n;
        if (node instanceof Elem) {
            Object object;
            Elem e = (Elem)node;
            sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), cur));
            scala.collection.immutable.Seq child = e.child();
            if (child.isEmpty() || this.allAreLeaves((scala.collection.immutable.Seq<Node>)child)) {
                sb.append(e.toString());
                return;
            }
            Elem elem = e;
            Elem emptyElem = elem.copy(elem.copy$default$1(), elem.copy$default$2(), elem.copy$default$3(), elem.copy$default$4(), false, this.mtChild);
            String tagsString = emptyElem.toString();
            String[] stringArray = tagsString.split("><");
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String partialStartTag = string;
            String partialEndTag = string2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)partialStartTag, (Object)partialEndTag);
            String partialStartTag2 = (String)tuple2._1();
            String partialEndTag2 = (String)tuple2._2();
            String startTag = partialStartTag2 + ">";
            String endTag = "<" + partialEndTag2;
            sb.append(startTag);
            ((IterableOnceOps)child.filterNot((Function1 & Serializable)_$2 -> _$2 instanceof Atom)).foreach((Function1)(JProcedure1 & Serializable)c -> {
                sb.append("\n");
                this.format((Node)c, sb, cur + this.step);
            });
            sb.append("\n");
            sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), cur));
            sb.append(endTag);
            return;
        }
        if (node instanceof ProcInstr) {
            ProcInstr pi = (ProcInstr)node;
            sb.append(n.toString());
            return;
        }
        if (node instanceof Comment) {
            Comment co = (Comment)node;
            sb.append(n.toString());
            return;
        }
        throw Assert$.MODULE$.invariantFailed("XML infoset node did not contain only other elements, PI or comments: " + n);
    }

    public String format(Node n) {
        Node c = this.minimizeScopes(n);
        StringBuilder sb = new StringBuilder();
        this.format(c, sb, 0);
        return sb.toString();
    }

    public String formatNodes(scala.collection.immutable.Seq<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        this.formatNodes(nodes, sb);
        return sb.toString();
    }

    public void formatNodes(scala.collection.immutable.Seq<Node> nodes, StringBuilder sb) {
        nodes.foreach((Function1 & Serializable)n -> sb.append(this.format((Node)n)));
    }
}

