/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.datatype.strings;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.core.values.StringValue;
import java.util.List;

public class BoundedStringEncoderImpl
extends StringEncoderImpl {
    protected final int valueMaxLength;
    protected final int valuePartitionCapacity;
    protected int globalID;
    protected StringEncoderImpl.ValueContainer[] globalIdMapping;

    public BoundedStringEncoderImpl(boolean localValuePartitions, int valueMaxLength, int valuePartitionCapacity) {
        super(localValuePartitions);
        this.valueMaxLength = valueMaxLength;
        this.valuePartitionCapacity = valuePartitionCapacity;
        this.globalID = -1;
        if (valuePartitionCapacity >= 0) {
            this.globalIdMapping = new StringEncoderImpl.ValueContainer[valuePartitionCapacity];
        }
    }

    @Override
    public void addValue(QNameContext context, String value) {
        if (this.valueMaxLength < 0 || value.length() <= this.valueMaxLength) {
            if (this.valuePartitionCapacity < 0) {
                super.addValue(context, value);
            } else if (this.valuePartitionCapacity != 0) {
                assert (!this.stringValues.containsKey(value));
                if (++this.globalID == this.valuePartitionCapacity) {
                    this.globalID = 0;
                }
                StringEncoderImpl.ValueContainer vc = new StringEncoderImpl.ValueContainer(value, context, this.getNumberOfStringValues(context), this.globalID);
                if (this.stringValues.size() == this.valuePartitionCapacity) {
                    StringEncoderImpl.ValueContainer vcFree = this.globalIdMapping[this.globalID];
                    this.freeStringValue(vcFree.context, vcFree.localValueID);
                    this.stringValues.remove(vcFree.value);
                }
                this.stringValues.put(value, vc);
                this.addLocalValue(context, new StringValue(value));
                this.globalIdMapping[this.globalID] = vc;
            }
        }
    }

    protected void freeStringValue(QNameContext qnc, int localValueID) {
        if (this.localValuePartitions) {
            assert (this.localValues.get(qnc) != null);
            List lvs = (List)this.localValues.get(qnc);
            assert (localValueID < lvs.size());
            assert (lvs.get(localValueID) != null);
            lvs.set(localValueID, null);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.globalID = -1;
    }
}

