/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.cpc.CpcCompression;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.apache.datasketches.cpc.PreambleUtil;
import org.apache.datasketches.cpc.RuntimeAsserts;

final class CompressedState {
    private boolean csvIsValid = false;
    private boolean windowIsValid = false;
    final int lgK;
    final short seedHash;
    int fiCol = 0;
    boolean mergeFlag = false;
    long numCoupons = 0L;
    double kxp;
    double hipEstAccum = 0.0;
    int numCsv = 0;
    int[] csvStream = null;
    int csvLengthInts = 0;
    int[] cwStream = null;
    int cwLengthInts = 0;

    private CompressedState(int lgK, short seedHash) {
        this.lgK = lgK;
        this.seedHash = seedHash;
        this.kxp = 1 << lgK;
    }

    static CompressedState compress(CpcSketch source) {
        short seedHash = Util.computeSeedHash(source.seed);
        CompressedState target = new CompressedState(source.lgK, seedHash);
        target.fiCol = source.fiCol;
        target.mergeFlag = source.mergeFlag;
        target.numCoupons = source.numCoupons;
        target.kxp = source.kxp;
        target.hipEstAccum = source.hipEstAccum;
        target.csvIsValid = source.pairTable != null;
        target.windowIsValid = source.slidingWindow != null;
        CpcCompression.compress(source, target);
        return target;
    }

    Flavor getFlavor() {
        return CpcUtil.determineFlavor(this.lgK, this.numCoupons);
    }

    Format getFormat() {
        int ordinal = (this.cwLengthInts > 0 ? 4 : 0) | (this.numCsv > 0 ? 2 : 0) | (this.mergeFlag ? 0 : 1);
        return Format.ordinalToFormat(ordinal);
    }

    int getWindowOffset() {
        return CpcUtil.determineCorrectOffset(this.lgK, this.numCoupons);
    }

    long getRequiredSerializedBytes() {
        Format format = this.getFormat();
        byte preInts = PreambleUtil.getDefinedPreInts(format);
        return 4L * (long)(preInts + this.csvLengthInts + this.cwLengthInts);
    }

    static CompressedState importFromSegment(MemorySegment seg) {
        PreambleUtil.checkLoPreamble(seg);
        RuntimeAsserts.rtAssert(PreambleUtil.isCompressed(seg));
        int lgK = PreambleUtil.getLgK(seg);
        short seedHash = PreambleUtil.getSeedHash(seg);
        CompressedState state = new CompressedState(lgK, seedHash);
        int fmtOrd = PreambleUtil.getFormatOrdinal(seg);
        Format format = Format.ordinalToFormat(fmtOrd);
        state.mergeFlag = (fmtOrd & 1) <= 0;
        state.csvIsValid = (fmtOrd & 2) > 0;
        state.windowIsValid = (fmtOrd & 4) > 0;
        switch (format) {
            case EMPTY_MERGED: 
            case EMPTY_HIP: {
                PreambleUtil.checkCapacity(seg.byteSize(), 8L);
                break;
            }
            case SPARSE_HYBRID_MERGED: {
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.numCsv = (int)state.numCoupons;
                state.csvLengthInts = PreambleUtil.getSvLengthInts(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.csvStream = PreambleUtil.getSvStream(seg);
                break;
            }
            case SPARSE_HYBRID_HIP: {
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.numCsv = (int)state.numCoupons;
                state.csvLengthInts = PreambleUtil.getSvLengthInts(seg);
                state.kxp = PreambleUtil.getKxP(seg);
                state.hipEstAccum = PreambleUtil.getHipAccum(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.csvStream = PreambleUtil.getSvStream(seg);
                break;
            }
            case PINNED_SLIDING_MERGED_NOSV: {
                state.fiCol = PreambleUtil.getFiCol(seg);
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.cwLengthInts = PreambleUtil.getWLengthInts(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.cwStream = PreambleUtil.getWStream(seg);
                break;
            }
            case PINNED_SLIDING_HIP_NOSV: {
                state.fiCol = PreambleUtil.getFiCol(seg);
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.cwLengthInts = PreambleUtil.getWLengthInts(seg);
                state.kxp = PreambleUtil.getKxP(seg);
                state.hipEstAccum = PreambleUtil.getHipAccum(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.cwStream = PreambleUtil.getWStream(seg);
                break;
            }
            case PINNED_SLIDING_MERGED: {
                state.fiCol = PreambleUtil.getFiCol(seg);
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.numCsv = PreambleUtil.getNumSv(seg);
                state.csvLengthInts = PreambleUtil.getSvLengthInts(seg);
                state.cwLengthInts = PreambleUtil.getWLengthInts(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.cwStream = PreambleUtil.getWStream(seg);
                state.csvStream = PreambleUtil.getSvStream(seg);
                break;
            }
            case PINNED_SLIDING_HIP: {
                state.fiCol = PreambleUtil.getFiCol(seg);
                state.numCoupons = PreambleUtil.getNumCoupons(seg);
                state.numCsv = PreambleUtil.getNumSv(seg);
                state.csvLengthInts = PreambleUtil.getSvLengthInts(seg);
                state.cwLengthInts = PreambleUtil.getWLengthInts(seg);
                state.kxp = PreambleUtil.getKxP(seg);
                state.hipEstAccum = PreambleUtil.getHipAccum(seg);
                PreambleUtil.checkCapacity(seg.byteSize(), state.getRequiredSerializedBytes());
                state.cwStream = PreambleUtil.getWStream(seg);
                state.csvStream = PreambleUtil.getSvStream(seg);
            }
        }
        PreambleUtil.checkCapacity(seg.byteSize(), 4L * (long)(PreambleUtil.getPreInts(seg) + state.csvLengthInts + state.cwLengthInts));
        return state;
    }

    void exportToSegment(MemorySegment wseg) {
        Format format = this.getFormat();
        switch (format) {
            case EMPTY_MERGED: {
                PreambleUtil.putEmptyMerged(wseg, this.lgK, this.seedHash);
                break;
            }
            case EMPTY_HIP: {
                PreambleUtil.putEmptyHip(wseg, this.lgK, this.seedHash);
                break;
            }
            case SPARSE_HYBRID_MERGED: {
                PreambleUtil.putSparseHybridMerged(wseg, this.lgK, (int)this.numCoupons, this.csvLengthInts, this.seedHash, this.csvStream);
                break;
            }
            case SPARSE_HYBRID_HIP: {
                PreambleUtil.putSparseHybridHip(wseg, this.lgK, (int)this.numCoupons, this.csvLengthInts, this.kxp, this.hipEstAccum, this.seedHash, this.csvStream);
                break;
            }
            case PINNED_SLIDING_MERGED_NOSV: {
                PreambleUtil.putPinnedSlidingMergedNoSv(wseg, this.lgK, this.fiCol, (int)this.numCoupons, this.cwLengthInts, this.seedHash, this.cwStream);
                break;
            }
            case PINNED_SLIDING_HIP_NOSV: {
                PreambleUtil.putPinnedSlidingHipNoSv(wseg, this.lgK, this.fiCol, (int)this.numCoupons, this.cwLengthInts, this.kxp, this.hipEstAccum, this.seedHash, this.cwStream);
                break;
            }
            case PINNED_SLIDING_MERGED: {
                PreambleUtil.putPinnedSlidingMerged(wseg, this.lgK, this.fiCol, (int)this.numCoupons, this.numCsv, this.csvLengthInts, this.cwLengthInts, this.seedHash, this.csvStream, this.cwStream);
                break;
            }
            case PINNED_SLIDING_HIP: {
                PreambleUtil.putPinnedSlidingHip(wseg, this.lgK, this.fiCol, (int)this.numCoupons, this.numCsv, this.kxp, this.hipEstAccum, this.csvLengthInts, this.cwLengthInts, this.seedHash, this.csvStream, this.cwStream);
            }
        }
    }

    public String toString() {
        return CompressedState.toString(this, false);
    }

    public static String toString(CompressedState state, boolean detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressedState").append(Util.LS);
        sb.append("  Flavor     : ").append((Object)state.getFlavor()).append(Util.LS);
        sb.append("  Format     : ").append((Object)state.getFormat()).append(Util.LS);
        sb.append("  lgK        : ").append(state.lgK).append(Util.LS);
        sb.append("  seedHash   : ").append(state.seedHash).append(Util.LS);
        sb.append("  fiCol      : ").append(state.fiCol).append(Util.LS);
        sb.append("  mergeFlag  : ").append(state.mergeFlag).append(Util.LS);
        sb.append("  csvStream  : ").append(state.csvIsValid).append(Util.LS);
        sb.append("  cwStream   : ").append(state.windowIsValid).append(Util.LS);
        sb.append("  numCoupons : ").append(state.numCoupons).append(Util.LS);
        sb.append("  kxp        : ").append(state.kxp).append(Util.LS);
        sb.append("  hipAccum   : ").append(state.hipEstAccum).append(Util.LS);
        sb.append("  numCsv     : ").append(state.numCsv).append(Util.LS);
        sb.append("  csvLengthInts  : ").append(state.csvLengthInts).append(Util.LS);
        sb.append("  csLength   : ").append(state.cwLengthInts).append(Util.LS);
        if (detail) {
            int i;
            if (state.csvStream != null) {
                sb.append("  CsvStream  : ").append(Util.LS);
                for (i = 0; i < state.csvLengthInts; ++i) {
                    sb.append(String.format("%8d %12d" + Util.LS, i, state.csvStream[i]));
                }
            }
            if (state.cwStream != null) {
                sb.append("  CwStream  : ").append(Util.LS);
                for (i = 0; i < state.cwLengthInts; ++i) {
                    sb.append(String.format("%8d %12d" + Util.LS, i, state.cwStream[i]));
                }
            }
        }
        return sb.toString();
    }
}

