/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.RelativeErrorTables;
import org.apache.datasketches.hll.TgtHllType;

abstract class BaseHllSketch
implements MemorySegmentStatus {
    BaseHllSketch() {
    }

    abstract void couponUpdate(int var1);

    public abstract int getCompactSerializationBytes();

    public abstract double getCompositeEstimate();

    abstract CurMode getCurMode();

    public abstract double getEstimate();

    public abstract TgtHllType getTgtHllType();

    public abstract int getLgConfigK();

    public abstract double getLowerBound(int var1);

    public static final int getSerializationVersion() {
        return 1;
    }

    public static final int getSerializationVersion(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.SER_VER_BYTE) & 0xFF;
    }

    public static double getRelErr(boolean upperBound, boolean oooFlag, int lgConfigK, int numStdDev) {
        HllUtil.checkLgK(lgConfigK);
        if (lgConfigK > 12) {
            double rseFactor = oooFlag ? HllUtil.HLL_NON_HIP_RSE_FACTOR : HllUtil.HLL_HIP_RSE_FACTOR;
            int configK = 1 << lgConfigK;
            return (double)numStdDev * rseFactor / Math.sqrt(configK);
        }
        return Math.abs(RelativeErrorTables.getRelErr(upperBound, oooFlag, lgConfigK, numStdDev));
    }

    public abstract int getUpdatableSerializationBytes();

    public abstract double getUpperBound(int var1);

    public abstract boolean isEmpty();

    public abstract boolean isCompact();

    public boolean isEstimationMode() {
        return true;
    }

    @Override
    public abstract boolean hasMemorySegment();

    @Override
    public abstract boolean isOffHeap();

    abstract boolean isOutOfOrder();

    @Override
    public abstract boolean isSameResource(MemorySegment var1);

    public abstract void reset();

    public abstract byte[] toCompactByteArray();

    public abstract byte[] toUpdatableByteArray();

    public String toString() {
        return this.toString(true, false, false, false);
    }

    public String toString(boolean summary, boolean detail, boolean auxDetail) {
        return this.toString(summary, detail, auxDetail, false);
    }

    public abstract String toString(boolean var1, boolean var2, boolean var3, boolean var4);

    public void update(long datum) {
        long[] data = new long[]{datum};
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(ByteBuffer data) {
        if (data == null || data.remaining() == 0) {
            return;
        }
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(char[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(int[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    public void update(long[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.couponUpdate(BaseHllSketch.coupon(MurmurHash3.hash(data, 9001L)));
    }

    private static final int coupon(long[] hash) {
        int addr26 = (int)(hash[0] & 0x3FFFFFFL);
        int lz = Long.numberOfLeadingZeros(hash[1]);
        int value = (lz > 62 ? 62 : lz) + 1;
        return value << 26 | addr26;
    }
}

