/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.internal.AllocateDirectWritableMap;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.MapNonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.MapWritableBufferImpl;
import org.apache.datasketches.memory.internal.MapWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.Util;

final class MapNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private final AllocateDirectWritableMap dirWMap;

    MapNonNativeWritableBufferImpl(AllocateDirectWritableMap dirWMap, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes) {
        super(capacityBytes);
        this.dirWMap = dirWMap;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = MapNonNativeWritableBufferImpl.removeNnBuf(typeId) | 0x10 | 0x40 | 0x20;
        this.cumOffsetBytes = cumOffsetBytes;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = MapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0x10 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new MapWritableBufferImpl(this.dirWMap, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes);
        }
        return new MapNonNativeWritableBufferImpl(this.dirWMap, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = MapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new MapWritableMemoryImpl(this.dirWMap, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes);
        }
        return new MapNonNativeWritableMemoryImpl(this.dirWMap, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = MapNonNativeWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 4 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new MapWritableBufferImpl(this.dirWMap, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes);
        }
        return new MapNonNativeWritableBufferImpl(this.dirWMap, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes);
    }

    @Override
    public void close() {
        this.checkValid();
        MapNonNativeWritableBufferImpl.checkThread(this.owner);
        this.dirWMap.close();
    }

    @Override
    public void force() {
        this.checkValid();
        MapNonNativeWritableBufferImpl.checkThread(this.owner);
        this.checkNotReadOnly();
        this.dirWMap.force();
    }

    @Override
    Object getUnsafeObject() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        this.checkValid();
        MapNonNativeWritableBufferImpl.checkThread(this.owner);
        return this.dirWMap.isLoaded();
    }

    @Override
    public boolean isAlive() {
        return this.dirWMap.getValid().get();
    }

    @Override
    public void load() {
        this.checkValid();
        MapNonNativeWritableBufferImpl.checkThread(this.owner);
        this.dirWMap.load();
    }
}

