/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XMLOptimizerTraceTest
extends GeneratedColumnsHelper {
    private static final String TRACE_FILE_NAME = "xott.xml";
    private static final String SAVED_TRACE_NAME = "xmlOptimizer.trace";
    private static final String FILE_EXISTS = "XIE0S";

    public XMLOptimizerTraceTest(String string) {
        super(string);
    }

    public static Test suite() {
        String[] stringArray = new String[]{"functionTests/tests/lang/xmlOptimizer.trace"};
        BaseTestSuite baseTestSuite = new BaseTestSuite("XMLOptimizerTraceTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(XMLOptimizerTraceTest.class));
        return new SupportFilesSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite), stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection connection = this.getConnection();
        if (!this.routineExists(connection, "INTEGERLIST")) {
            this.goodStatement(connection, "create function integerList()\nreturns table( a int, b int, c int, d int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        }
        if (!this.routineExists(connection, "GETRESULTSETMETADATA")) {
            this.goodStatement(connection, "create function getResultSetMetaData( query varchar( 32672 ) )\nreturns table\n(\n        getCatalogName varchar( 32672 ),\n        getColumnClassName varchar( 32672 ),\n        getColumnDisplaySize int,\n        getColumnLabel varchar( 32672 ),\n        getColumnName varchar( 32672 ),\n        getColumnType int,\n        getColumnTypeName varchar( 32672 ),\n        getPrecision int,\n        getScale int,\n        getSchemaName varchar( 32672 ),\n        getTableName varchar( 32672 ),\n        isAutoIncrement boolean,\n        isCaseSensitive boolean,\n        isCurrency boolean,\n        isDefinitelyWritable boolean,\n        isNullable int,\n        isReadOnly boolean,\n        isSearchable boolean,\n        isSigned boolean,\n        isWritable boolean\n)\nlanguage java parameter style derby_jdbc_result_set reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RSMDWrapper.getResultSetMetaData'\n");
        }
        if (!this.tableExists(connection, "T")) {
            this.goodStatement(connection, "create table t( a int, b varchar( 100 ) )");
            this.goodStatement(connection, "create index t_a on t( a )");
        }
        if (!this.tableExists(connection, "S")) {
            this.goodStatement(connection, "create table s( a int, b varchar( 100 ) )");
            this.goodStatement(connection, "create index s_a on s( a )");
        }
        if (!this.tableExists(connection, "R")) {
            this.goodStatement(connection, "create table r( a int, b varchar( 100 ) )");
            this.goodStatement(connection, "create index r_a on r( a )");
        }
        if (!this.tableExists(connection, "T1")) {
            this.goodStatement(connection, "create table t1( c1 int, c2 int, c3 int )");
        }
        if (!this.tableExists(connection, "T2")) {
            this.goodStatement(connection, "create table t2( c1 int, c2 int, c3 int )");
        }
        if (!this.tableExists(connection, "T3")) {
            this.goodStatement(connection, "create table t3( c1 int, c2 int, c3 int )");
        }
    }

    public void test_01_planCost() throws Exception {
        Connection connection = this.getConnection();
        File file = SupportFilesSetup.getReadWrite(TRACE_FILE_NAME);
        SupportFilesSetup.deleteFile(file);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'xml' )");
        this.goodStatement(connection, "select s.a from t, s where t.a = s.a");
        this.goodStatement(connection, "select s.a from t, s, r where t.a = s.a and s.a = r.a");
        this.goodStatement(connection, "select s.a from s, table( integerList() ) i where s.a = i.a");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false, '" + file.getPath() + "' )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', true, '" + file.getPath() + "' )");
        this.assertResults(connection, "select getColumnName, getColumnTypeName, getPrecision from table( getResultSetMetaData( 'select * from planCost where 1=2' ) ) g", new String[][]{{"TEXT", "VARCHAR", "32672"}, {"STMTID", "INTEGER", "10"}, {"QBID", "INTEGER", "10"}, {"COMPLETE", "BOOLEAN", "1"}, {"SUMMARY", "VARCHAR", "32672"}, {"TYPE", "VARCHAR", "50"}, {"ESTIMATEDCOST", "DOUBLE", "15"}, {"ESTIMATEDROWCOUNT", "BIGINT", "19"}}, false);
        this.assertResults(connection, "select distinct stmtID, summary from planCost where complete order by stmtID, summary", new String[][]{{"1", "( \"APP\".\"S_A\" # \"APP\".\"T_A\" )"}, {"1", "( \"APP\".\"T_A\" # \"APP\".\"S_A\" )"}, {"2", "( ( \"APP\".\"R_A\" # \"APP\".\"S_A\" ) * \"APP\".\"T_A\" )"}, {"2", "( ( \"APP\".\"R_A\" # \"APP\".\"T_A\" ) * \"APP\".\"S_A\" )"}, {"2", "( ( \"APP\".\"S_A\" # \"APP\".\"R_A\" ) * \"APP\".\"T_A\" )"}, {"2", "( ( \"APP\".\"S_A\" # \"APP\".\"T_A\" ) * \"APP\".\"R_A\" )"}, {"2", "( ( \"APP\".\"T_A\" # \"APP\".\"R_A\" ) * \"APP\".\"S_A\" )"}, {"2", "( ( \"APP\".\"T_A\" # \"APP\".\"S_A\" ) * \"APP\".\"R_A\" )"}, {"3", "( \"APP\".\"INTEGERLIST\"() # \"APP\".\"S_A\" )"}, {"3", "( \"APP\".\"S_A\" # \"APP\".\"INTEGERLIST\"() )"}}, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', false )");
        this.vetOuterJoin(connection);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'xml' )");
        this.expectExecutionError(connection, FILE_EXISTS, "call syscs_util.syscs_register_tool( 'optimizerTracing', false, '" + file.getPath() + "' )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false )");
    }

    public void test_02_xmlVTI() throws Exception {
        Connection connection = this.getConnection();
        File file = SupportFilesSetup.getReadOnly(SAVED_TRACE_NAME);
        URL uRL = SupportFilesSetup.getReadOnlyURL(SAVED_TRACE_NAME);
        String[][] stringArray = new String[][]{{"1", "R_A", "HASH", "20.1395", "6"}, {"1", "R_A", "NESTEDLOOP", "20.039500000000004", "6"}, {"1", "S_A", "HASH", "20.1395", "6"}, {"1", "S_A", "NESTEDLOOP", "20.039500000000004", "6"}, {"1", "T_A", "HASH", "20.1395", "6"}, {"1", "T_A", "NESTEDLOOP", "20.039500000000004", "6"}};
        String[][] stringArray2 = new String[][]{{"R_A", "HASH", "20.1395", "6"}, {"R_A", "NESTEDLOOP", "20.039500000000004", "6"}, {"S_A", "HASH", "20.1395", "6"}, {"S_A", "NESTEDLOOP", "20.039500000000004", "6"}, {"T_A", "HASH", "20.1395", "6"}, {"T_A", "NESTEDLOOP", "20.039500000000004", "6"}};
        this.goodStatement(connection, "create type ArrayList external name 'java.util.ArrayList' language java");
        this.goodStatement(connection, "create function asList( cell varchar( 32672 ) ... ) returns ArrayList\nlanguage java parameter style derby no sql\nexternal name 'org.apache.derby.vti.XmlVTI.asList'\n");
        this.goodStatement(connection, "create function decorationWithParentInfo\n(\n    fileName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n        qbID int,\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 20 ),\n        estimatedCost double,\n        estimatedRowCount int\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n");
        this.goodStatement(connection, "create view decorationWithParentInfo as\nselect * from table\n(\n    decorationWithParentInfo\n    (\n        '" + file.getPath() + "',\n        'decoration',\n        asList( 'qbID' ),\n        asList( 'decConglomerateName', 'decJoinStrategy', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n    )\n) v\n");
        this.goodStatement(connection, "create function decorationChildOnly\n(\n    fileName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 20 ),\n        estimatedCost double,\n        estimatedRowCount int\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n");
        this.goodStatement(connection, "create view decorationChildOnly as\nselect * from table\n(\n    decorationChildOnly\n    (\n        '" + file.getPath() + "',\n        'decoration',\n        'decConglomerateName', 'decJoinStrategy', 'ceEstimatedCost', 'ceEstimatedRowCount'\n    )\n) v\n");
        this.goodStatement(connection, "create function decorationURLParentInfo\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n        qbID int,\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 20 ),\n        estimatedCost double,\n        estimatedRowCount int\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
        this.goodStatement(connection, "create view decorationURLParentInfo as\nselect * from table\n(\n    decorationURLParentInfo\n    (\n        '" + uRL.toString() + "',\n        'decoration',\n        asList( 'qbID' ),\n        asList( 'decConglomerateName', 'decJoinStrategy', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n    )\n) v\n");
        this.goodStatement(connection, "create function decorationURLChildOnly\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 20 ),\n        estimatedCost double,\n        estimatedRowCount int\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
        this.goodStatement(connection, "create view decorationURLChildOnly as\nselect * from table\n(\n    decorationURLChildOnly\n    (\n        '" + uRL.toString() + "',\n        'decoration',\n        'decConglomerateName', 'decJoinStrategy', 'ceEstimatedCost', 'ceEstimatedRowCount'\n    )\n) v\n");
        this.assertResults(connection, "select distinct qbID, conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\nfrom decorationWithParentInfo\nwhere conglomerateName like '%_A' and estimatedCost is not null\norder by qbID, conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\n", stringArray, false);
        this.assertResults(connection, "select distinct conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\nfrom decorationChildOnly\nwhere conglomerateName like '%_A' and estimatedCost is not null\norder by conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\n", stringArray2, false);
        this.assertResults(connection, "select distinct qbID, conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\nfrom decorationURLParentInfo\nwhere conglomerateName like '%_A' and estimatedCost is not null\norder by qbID, conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\n", stringArray, false);
        this.assertResults(connection, "select distinct conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\nfrom decorationURLChildOnly\nwhere conglomerateName like '%_A' and estimatedCost is not null\norder by conglomerateName, joinStrategy, estimatedCost, estimatedRowCount\n", stringArray2, false);
        this.goodStatement(connection, "drop view decorationURLChildOnly");
        this.goodStatement(connection, "drop function decorationURLChildOnly");
        this.goodStatement(connection, "drop view decorationURLParentInfo");
        this.goodStatement(connection, "drop function decorationURLParentInfo");
        this.goodStatement(connection, "drop view decorationChildOnly");
        this.goodStatement(connection, "drop function decorationChildOnly");
        this.goodStatement(connection, "drop view decorationWithParentInfo");
        this.goodStatement(connection, "drop function decorationWithParentInfo");
        this.goodStatement(connection, "drop function asList");
        this.goodStatement(connection, "drop type ArrayList restrict");
    }

    private void vetOuterJoin(Connection connection) throws Exception {
        File file = SupportFilesSetup.getReadWrite(TRACE_FILE_NAME);
        SupportFilesSetup.deleteFile(file);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'xml' )");
        this.goodStatement(connection, "select * from t3, (t1 left outer join t2 on t1.c1 = t2.c1) where t3.c1 = t1.c1");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false, '" + file.getPath() + "' )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', true, '" + file.getPath() + "' )");
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select distinct summary from planCost\nwhere complete and qbID = 1\norder by summary\n");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string = resultSet.getString(1).trim();
        resultSet.next();
        String string2 = resultSet.getString(1).trim();
        XMLOptimizerTraceTest.assertTrue((boolean)string.startsWith("( \"APP\"."));
        XMLOptimizerTraceTest.assertTrue((boolean)string.endsWith(" * ProjectRestrictNode )"));
        XMLOptimizerTraceTest.assertTrue((boolean)string2.startsWith("( ProjectRestrictNode # \"APP\"."));
        resultSet.close();
        preparedStatement.close();
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracingViews', false )");
    }

    private boolean routineExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.sysaliases where alias = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private boolean tableExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.systables where tablename = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }
}

