/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.variable.Variable;
import org.apache.torque.generator.variable.VariableStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutletImpl
implements Outlet {
    private static Log log = LogFactory.getLog(OutletImpl.class);
    private final Map<String, MergepointMapping> mergepointMappings = new HashMap<String, MergepointMapping>();
    private final QualifiedName name;
    private String inputElementName;

    public OutletImpl(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
    }

    @Override
    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public String getInputElementName() {
        return this.inputElementName;
    }

    @Override
    public void setInputElementName(String inputElementName) {
        this.inputElementName = inputElementName;
    }

    @Override
    public void addMergepointMapping(MergepointMapping mergepointMapping) throws ConfigurationException {
        MergepointMapping oldMapping = this.mergepointMappings.get(mergepointMapping.getName());
        if (oldMapping != null) {
            throw new ConfigurationException("Attempted to add another mergepoint mapping for the name " + mergepointMapping.getName() + " : New mapping mapped to Actions " + mergepointMapping.getActions() + ", old mapping mapped to Actions " + oldMapping.getActions());
        }
        this.mergepointMappings.put(mergepointMapping.getName(), mergepointMapping);
    }

    @Override
    public MergepointMapping setMergepointMapping(MergepointMapping mergepointMapping) {
        return this.mergepointMappings.put(mergepointMapping.getName(), mergepointMapping);
    }

    @Override
    public MergepointMapping getMergepointMapping(String name) {
        return this.mergepointMappings.get(name);
    }

    @Override
    public Map<String, MergepointMapping> getMergepointMappings() {
        return Collections.unmodifiableMap(this.mergepointMappings);
    }

    @Override
    public void beforeExecute(ControllerState controllerState) throws GeneratorException {
        controllerState.pushOutlet(this);
        controllerState.getVariableStore().startOutlet();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing outlet " + this.getName() + " on element " + SourcePath.getPathAsString(controllerState.getSourceElement())));
        }
    }

    @Override
    public void afterExecute(ControllerState controllerState) {
        controllerState.getVariableStore().endOutlet();
        controllerState.popOutlet();
    }

    @Override
    public abstract OutletResult execute(ControllerState var1) throws GeneratorException;

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(name=").append(this.name).append(",");
        result.append("inputElementName=").append(this.inputElementName);
        result.append(")");
        return result.toString();
    }

    public void setVariable(String key, Object value, ControllerState controllerState) {
        this.setVariable(key, value, Variable.Scope.CHILDREN, controllerState);
    }

    public void setVariable(String key, Object value, Variable.Scope scope, ControllerState controllerState) {
        QualifiedName qualifiedName = controllerState.getQualifiedName(key);
        Variable variable = new Variable(qualifiedName, value, scope);
        VariableStore variableStore = controllerState.getVariableStore();
        variableStore.set(variable);
    }

    public Object getVariable(String key, ControllerState controllerState) {
        QualifiedName qualifiedName = controllerState.getQualifiedName(key);
        VariableStore variableStore = controllerState.getVariableStore();
        Variable variable = variableStore.getInHierarchy(qualifiedName);
        Object value = null;
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public String mergepoint(String mergepointName, ControllerState controllerState) throws GeneratorException {
        MergepointMapping mergepointMapping;
        if (log.isDebugEnabled()) {
            log.debug((Object)("mergepoint() : Start for mergepoint " + mergepointName));
        }
        if ((mergepointMapping = this.getMergepointMapping(mergepointName)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("mergepoint() : End. Mapping " + mergepointName + " not found in outlet " + this.getName() + ", returning the empty String"));
            }
            return "";
        }
        List<MergepointAction> actions = mergepointMapping.getActions();
        if (actions.isEmpty()) {
            log.debug((Object)("No actions specified for action mapping with name " + mergepointName + " in outlet " + controllerState.getOutlet().getName() + " while generating to " + controllerState.getOutputFile() + " Returning the empty String."));
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (MergepointAction action : actions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergepoint() : Executing action " + action));
            }
            try {
                OutletResult actionResult = action.execute(controllerState);
                if (!actionResult.isStringResult()) {
                    throw new GeneratorException("mergepoint actions must return a String result! Mergepoint name: " + mergepointName + ", outlet name: " + controllerState.getOutlet().getName().toString());
                }
                result.append(actionResult.getStringResult());
            }
            catch (GeneratorException e) {
                log.error((Object)("mergepoint() : Error executing action " + action), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                log.error((Object)("mergepoint() : Error executing action " + action), (Throwable)e);
                throw e;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("mergepoint() : End for mergepoint " + mergepointName));
        }
        return result.toString();
    }
}

