/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryConfigurationProvider
extends AbstractConfigurationProvider {
    private static Log log = LogFactory.getLog(DirectoryConfigurationProvider.class);
    private ProjectPaths projectPaths;
    private TorqueGeneratorPaths configurationPaths;

    public DirectoryConfigurationProvider(ProjectPaths projectPaths, TorqueGeneratorPaths configurationPaths) {
        super(configurationPaths);
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths is null");
        }
        this.projectPaths = projectPaths;
        this.configurationPaths = configurationPaths;
    }

    @Override
    public String getControlConfigurationLocation() throws ConfigurationException {
        return this.getFile(this.configurationPaths.getControlConfigurationFile(), this.configurationPaths.getConfigurationDirectory(), "control file").getAbsolutePath();
    }

    private File getFile(String name, String directory, String description) throws ConfigurationException {
        File file = null;
        try {
            File configDir = new File(this.projectPaths.getConfigurationPath(), directory);
            file = new File(configDir, name);
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new ConfigurationException("Canonical name for " + description + file + " could not be calculated", e);
        }
        return file;
    }

    @Override
    protected InputStream getInputStream(String name, String directory, String description) throws ConfigurationException {
        FileInputStream inputStream;
        File file = this.getFile(name, directory, description);
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(description + " file " + file.getAbsolutePath() + " not found", e);
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading " + description + " file: '" + file.getAbsolutePath() + "'"));
        }
        return bis;
    }

    @Override
    public Collection<String> getOutletConfigurationNames() throws ConfigurationException {
        File outletConfigDir = new File(this.projectPaths.getConfigurationPath(), this.configurationPaths.getOutletDirectory());
        ArrayList<String> result = new ArrayList<String>();
        if (!outletConfigDir.isDirectory()) {
            throw new ConfigurationException("OutletsConfigDirectory " + outletConfigDir.getAbsolutePath() + "must be a directory");
        }
        File[] sourceFiles = outletConfigDir.listFiles();
        for (int fileNr = 0; fileNr < sourceFiles.length; ++fileNr) {
            if (sourceFiles[fileNr].isDirectory() || !sourceFiles[fileNr].getPath().endsWith("xml")) continue;
            String name = sourceFiles[fileNr].getName();
            result.add(name);
        }
        return result;
    }
}

