/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.option.MapOptionsConfiguration;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.paths.CustomProjectPaths;
import org.apache.torque.generator.configuration.paths.DefaultTorqueGeneratorPaths;
import org.apache.torque.generator.configuration.paths.Maven2DirectoryProjectPaths;
import org.apache.torque.generator.configuration.paths.Maven2JarProjectPaths;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;
import org.apache.torque.generator.control.Controller;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.stream.FileSourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorqueGeneratorMojo
extends AbstractMojo
implements Mojo {
    private String packaging;
    private File projectRootDir;
    private File configDir;
    private String configPackage;
    private File sourceDir;
    private Set<String> sourceIncludes;
    private Set<String> sourceExcludes;
    private Boolean combineFiles;
    private File defaultOutputDir;
    private Map<String, String> outputDirMap = new HashMap<String, String>();
    private File workDir;
    private String jarFile;
    private String defaultOutputDirUsage;
    private Map<String, String> outputDirUsageMap = new HashMap<String, String>();
    private File overrideConfigDir;
    private String overrideConfigPackage;
    private String loglevel;
    private boolean addDebuggingInfoToOutput = false;
    private Map<String, String> options;
    private File optionsFile;
    private String defaultOutputEncoding;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        UnitDescriptor parentUnitDescriptor;
        CustomProjectPaths childProjectPaths;
        String encoding;
        Maven2JarProjectPaths defaultProjectPaths;
        UnitDescriptor.Packaging packaging;
        Controller controller = new Controller();
        ArrayList<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
        OutputDirUsage defaultOutputDirUsageConverted = OutputDirUsage.get(this.defaultOutputDirUsage);
        HashMap<String, OutputDirUsage> outputDirUsageConvertedMap = new HashMap<String, OutputDirUsage>();
        for (Map.Entry<String, String> outputDirUsageEntry : this.outputDirUsageMap.entrySet()) {
            outputDirUsageConvertedMap.put(outputDirUsageEntry.getKey(), OutputDirUsage.get(outputDirUsageEntry.getValue()));
        }
        if ("jar".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.JAR;
        } else if ("directory".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.DIRECTORY;
        } else if ("classpath".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.CLASSPATH;
        } else {
            throw new IllegalArgumentException("Unknown packaging " + this.packaging + ", must be jar, directory or classpath");
        }
        this.getLog().debug((CharSequence)("Packaging is " + packaging));
        if (UnitDescriptor.Packaging.JAR == packaging) {
            defaultProjectPaths = new Maven2JarProjectPaths(this.projectRootDir, this.jarFile);
        } else if (UnitDescriptor.Packaging.DIRECTORY == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else {
            throw new IllegalStateException("Unknown packaging" + packaging);
        }
        CustomProjectPaths projectPaths = new CustomProjectPaths((ProjectPaths)defaultProjectPaths);
        if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            if (this.configPackage == null) {
                throw new MojoExecutionException("configPackage must be set for packaging =\"classpath\"");
            }
            projectPaths.setConfigurationPackage(this.configPackage);
            projectPaths.setConfigurationDir(null);
        } else if (this.configDir != null) {
            projectPaths.setConfigurationDir(this.configDir);
            this.getLog().debug((CharSequence)("Setting config dir to " + this.configDir.toString()));
        }
        if (this.sourceDir != null) {
            projectPaths.setSourceDir(this.sourceDir);
            this.getLog().debug((CharSequence)("Setting source dir to " + this.sourceDir.toString()));
        }
        FileSourceProvider fileSourceProvider = null;
        if (this.sourceIncludes != null || this.sourceExcludes != null) {
            Fileset sourceFileset = new Fileset(projectPaths.getDefaultSourcePath(), this.sourceIncludes, this.sourceExcludes);
            this.getLog().debug((CharSequence)("Setting source includes to " + this.sourceIncludes));
            this.getLog().debug((CharSequence)("Setting source excludes to " + this.sourceExcludes));
            try {
                fileSourceProvider = new FileSourceProvider(null, sourceFileset, this.combineFiles);
            }
            catch (ConfigurationException e) {
                throw new MojoExecutionException("The source provider cannot be instantiated", (Exception)((Object)e));
            }
        }
        projectPaths.setOutputDirectory(null, this.defaultOutputDir);
        this.getLog().debug((CharSequence)("Setting defaultOutputDir to " + this.defaultOutputDir.toString()));
        if (this.outputDirMap != null) {
            if (this.outputDirMap.get("modifiable") == null) {
                this.outputDirMap.put("modifiable", this.project.getBasedir() + "/" + "src/main/generated-java");
            }
            for (Map.Entry<String, String> outputDirMapEntry : this.outputDirMap.entrySet()) {
                projectPaths.setOutputDirectory(outputDirMapEntry.getKey(), new File(outputDirMapEntry.getValue()));
                this.getLog().debug((CharSequence)("Setting output directory with key " + outputDirMapEntry.getKey() + " to " + outputDirMapEntry.getValue()));
            }
        }
        if (this.workDir != null) {
            projectPaths.setWorkDir(this.workDir);
            this.getLog().debug((CharSequence)("Setting workDir to " + this.workDir.toString()));
        }
        this.getLog().debug((CharSequence)("ProjectPaths = " + projectPaths));
        MapOptionsConfiguration optionConfiguration = null;
        if (this.options != null || this.optionsFile != null) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            if (this.optionsFile != null) {
                Properties optionProperties = new Properties();
                FileInputStream optionsFileInputStream = null;
                try {
                    optionsFileInputStream = new FileInputStream(this.optionsFile);
                    optionProperties.load(optionsFileInputStream);
                }
                catch (FileNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage());
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage());
                }
                finally {
                    if (optionsFileInputStream != null) {
                        try {
                            optionsFileInputStream.close();
                        }
                        catch (IOException e) {
                            this.getLog().error((Throwable)e);
                        }
                    }
                }
                this.getLog().debug((CharSequence)("loaded options file from " + this.optionsFile.getAbsolutePath() + ", contents: " + optionProperties));
                for (Map.Entry<Object, Object> propertiesEntry : optionProperties.entrySet()) {
                    if (this.options.containsKey(propertiesEntry.getKey())) continue;
                    this.options.put((String)propertiesEntry.getKey(), (String)propertiesEntry.getValue());
                }
            }
            this.getLog().debug((CharSequence)("options = " + this.options));
            optionConfiguration = new MapOptionsConfiguration(this.options);
        }
        Loglevel convertedLoglevel = null;
        if (this.loglevel != null) {
            convertedLoglevel = Loglevel.getByKey((String)this.loglevel);
        }
        if ((encoding = this.defaultOutputEncoding) == null) {
            encoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
        }
        UnitDescriptor unitDescriptor = new UnitDescriptor(packaging, (ProjectPaths)projectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideSourceProvider((SourceProvider)fileSourceProvider);
        unitDescriptor.setOverrideOptions((OptionsConfiguration)optionConfiguration);
        unitDescriptor.setLoglevel(convertedLoglevel);
        unitDescriptor.setDefaultOutputEncoding(encoding);
        unitDescriptor.setAddDebuggingInfoToOutput(this.addDebuggingInfoToOutput);
        this.getLog().debug((CharSequence)"unit descriptor created");
        if (this.overrideConfigDir != null) {
            childProjectPaths = new CustomProjectPaths((ProjectPaths)projectPaths);
            childProjectPaths.setConfigurationDir(this.overrideConfigDir);
            parentUnitDescriptor = new UnitDescriptor(UnitDescriptor.Packaging.DIRECTORY, (ProjectPaths)childProjectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
            parentUnitDescriptor.setInheritsFrom(unitDescriptor);
            parentUnitDescriptor.setOverrideSourceProvider((SourceProvider)fileSourceProvider);
            parentUnitDescriptor.setOverrideOptions((OptionsConfiguration)optionConfiguration);
            parentUnitDescriptor.setLoglevel(convertedLoglevel);
            parentUnitDescriptor.setDefaultOutputEncoding(encoding);
            this.getLog().debug((CharSequence)"child unit descriptor created from directory");
            unitDescriptor = parentUnitDescriptor;
        } else if (this.overrideConfigPackage != null) {
            childProjectPaths = new CustomProjectPaths((ProjectPaths)projectPaths);
            childProjectPaths.setConfigurationPackage(this.overrideConfigPackage);
            parentUnitDescriptor = new UnitDescriptor(UnitDescriptor.Packaging.CLASSPATH, (ProjectPaths)childProjectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
            parentUnitDescriptor.setInheritsFrom(unitDescriptor);
            parentUnitDescriptor.setOverrideSourceProvider((SourceProvider)fileSourceProvider);
            parentUnitDescriptor.setOverrideOptions((OptionsConfiguration)optionConfiguration);
            parentUnitDescriptor.setLoglevel(convertedLoglevel);
            parentUnitDescriptor.setDefaultOutputEncoding(encoding);
            this.getLog().debug((CharSequence)"child unit descriptor created from package");
            unitDescriptor = parentUnitDescriptor;
        }
        unitDescriptors.add(unitDescriptor);
        try {
            this.getLog().debug((CharSequence)"Generation started");
            controller.run(unitDescriptors);
            this.getLog().info((CharSequence)"Generation successful");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        File defaultOutputDirPath = projectPaths.getOutputDirectory(null);
        if (defaultOutputDirPath.exists()) {
            switch (defaultOutputDirUsageConverted) {
                case COMPILE: {
                    this.project.addCompileSourceRoot(defaultOutputDirPath.toString());
                    this.getLog().debug((CharSequence)("Added " + defaultOutputDirPath.toString() + " as compile source root"));
                    break;
                }
                case TEST_COMPILE: {
                    this.project.addTestCompileSourceRoot(defaultOutputDirPath.toString());
                    this.getLog().debug((CharSequence)("Added " + defaultOutputDirPath.toString() + " as test compile source root"));
                    break;
                }
                case RESOURCE: {
                    Resource resource = new Resource();
                    resource.setDirectory(defaultOutputDirPath.toString());
                    this.project.addResource(resource);
                    this.getLog().debug((CharSequence)("Added " + defaultOutputDirPath.toString() + " to the project resources"));
                    break;
                }
                case TEST_RESOURCE: {
                    Resource resource = new Resource();
                    resource.setDirectory(defaultOutputDirPath.toString());
                    this.project.addTestResource(resource);
                    this.getLog().debug((CharSequence)("Added " + defaultOutputDirPath.toString() + " to the project test resources"));
                    break;
                }
            }
        } else {
            this.getLog().info((CharSequence)("defaultOutputDirPath " + defaultOutputDirPath.getAbsolutePath() + " does not exist, not applying defaultOutputDirUsage"));
        }
        if (outputDirUsageConvertedMap.get("modifiable") == null && this.outputDirMap.get("modifiable") != null) {
            outputDirUsageConvertedMap.put("modifiable", OutputDirUsage.COMPILE);
        }
        for (Map.Entry usageEntry : outputDirUsageConvertedMap.entrySet()) {
            String outputDirPath = this.outputDirMap.get(usageEntry.getKey());
            if (outputDirPath == null) {
                this.getLog().info((CharSequence)("outputDirPath set for key " + (String)usageEntry.getKey() + " ignoring this outputDirUsageMap entry"));
                continue;
            }
            File outputDirFile = new File(outputDirPath);
            if (!outputDirFile.exists()) {
                this.getLog().info((CharSequence)("outputDirPath " + outputDirFile.getAbsolutePath() + " for outputDirUsageMap with key " + (String)usageEntry.getKey() + " does not exist," + " ignoring this outputDirUsageMap entry"));
                continue;
            }
            switch ((OutputDirUsage)((Object)usageEntry.getValue())) {
                case COMPILE: {
                    this.project.addCompileSourceRoot(outputDirPath.toString());
                    this.getLog().debug((CharSequence)("Added " + outputDirPath.toString() + " as compile source root"));
                    break;
                }
                case TEST_COMPILE: {
                    this.project.addTestCompileSourceRoot(outputDirPath.toString());
                    this.getLog().debug((CharSequence)("Added " + outputDirPath.toString() + " as test compile source root"));
                    break;
                }
                case RESOURCE: {
                    Resource resource = new Resource();
                    resource.setDirectory(outputDirPath.toString());
                    this.project.addResource(resource);
                    this.getLog().debug((CharSequence)("Added " + outputDirPath.toString() + " to the project resources"));
                    break;
                }
                case TEST_RESOURCE: {
                    Resource resource = new Resource();
                    resource.setDirectory(outputDirPath.toString());
                    this.project.addTestResource(resource);
                    this.getLog().debug((CharSequence)("Added " + outputDirPath.toString() + " to the project test resources"));
                    break;
                }
            }
        }
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setProjectRootDir(File projectRootDir) {
        this.projectRootDir = projectRootDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setDefaultOutputDir(File outputDir) {
        this.defaultOutputDir = outputDir;
    }

    public void setOutputDir(String outputDirKey, String outputDir) {
        this.outputDirMap.put(outputDirKey, outputDir);
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setDefaultOutputDirUsage(String defaultOutputDirUsage) {
        if (defaultOutputDirUsage == null) {
            throw new NullPointerException("defaultOutputDirUsage must not be null");
        }
        this.defaultOutputDirUsage = defaultOutputDirUsage;
    }

    public void setOutputDirUsage(String outputDirKey, String outputDirUsage) {
        if (outputDirKey == null) {
            throw new NullPointerException("outputDirKey must not be null");
        }
        if (outputDirUsage == null) {
            throw new NullPointerException("modifiedFileTargetDirUsage must not be null");
        }
        this.outputDirUsageMap.put(outputDirKey, outputDirUsage);
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setSourceIncludes(Set<String> sourceIncludes) {
        this.sourceIncludes = sourceIncludes;
    }

    public void setSourceExcludes(Set<String> sourceExcludes) {
        this.sourceExcludes = sourceExcludes;
    }

    public void setOverrideConfigDir(File overrideConfigDir) {
        this.overrideConfigDir = overrideConfigDir;
    }

    public void setOverrideConfigPackage(String overrideConfigPackage) {
        this.overrideConfigPackage = overrideConfigPackage;
    }

    public void setLoglevel(String loglevel) {
        this.loglevel = loglevel;
    }

    public void setDefaultOutputEncoding(String defaultOutputEncoding) {
        this.defaultOutputEncoding = defaultOutputEncoding;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void setCombineFiles(Boolean combineFiles) {
        this.combineFiles = combineFiles;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setOptionsFile(File optionsFile) {
        this.optionsFile = optionsFile;
    }

    public void setAddDebuggingInfoToOutput(boolean addDebuggingInfoToOutput) {
        this.addDebuggingInfoToOutput = addDebuggingInfoToOutput;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputDirUsage {
        COMPILE("compile"),
        TEST_COMPILE("test-compile"),
        RESOURCE("resource"),
        TEST_RESOURCE("test-resource"),
        NONE("none");

        private final String key;

        private OutputDirUsage(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public static OutputDirUsage get(String key) throws MojoExecutionException {
            for (OutputDirUsage candidate : OutputDirUsage.values()) {
                if (!candidate.getKey().equals(key)) continue;
                return candidate;
            }
            StringBuilder errorMessage = new StringBuilder().append("targetDirUsage contains illegal value: ").append(key).append(". Possible values are :");
            for (OutputDirUsage targetDirUsage : OutputDirUsage.values()) {
                errorMessage.append(" ").append(targetDirUsage.getKey());
            }
            throw new MojoExecutionException(errorMessage.toString());
        }
    }
}

