/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.tools.WideningCategories;

public class TernaryExpression
extends Expression {
    private final BooleanExpression booleanExpression;
    private final Expression truthExpression;
    private final Expression falseExpression;

    public TernaryExpression(BooleanExpression booleanExpression, Expression truthExpression, Expression falseExpression) {
        this.booleanExpression = booleanExpression;
        this.truthExpression = truthExpression;
        this.falseExpression = falseExpression;
    }

    public BooleanExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    public Expression getTrueExpression() {
        return this.truthExpression;
    }

    public Expression getFalseExpression() {
        return this.falseExpression;
    }

    @Override
    public String getText() {
        return "(" + this.getBooleanExpression().getText() + ") ? " + this.getTrueExpression().getText() + " : " + this.getFalseExpression().getText();
    }

    @Override
    public ClassNode getType() {
        return WideningCategories.lowestUpperBound(this.getTrueExpression().getType(), this.getFalseExpression().getType());
    }

    public String toString() {
        return super.toString() + "[" + this.getBooleanExpression() + " ? " + this.getTrueExpression() + " : " + this.getFalseExpression() + "]";
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        TernaryExpression ret = new TernaryExpression((BooleanExpression)transformer.transform(this.getBooleanExpression()), transformer.transform(this.getTrueExpression()), transformer.transform(this.getFalseExpression()));
        ret.setSourcePosition(this);
        ret.copyNodeMetaData(this);
        return ret;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitTernaryExpression(this);
    }
}

