/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.util.Locale;

public enum OperatingSystem {
    AIX,
    FREEBSD,
    LINUX,
    MAC,
    OPENBSD,
    SOLARIS,
    WINDOWS,
    OTHER;

    private static final OperatingSystem CURRENT_OS;

    public static OperatingSystem current() {
        return CURRENT_OS;
    }

    private static OperatingSystem determineCurrentOs() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new IllegalStateException("Unable to determine current operating system: system property 'os.name' is not set.");
        }
        return OperatingSystem.parse(osName);
    }

    private static OperatingSystem parse(String osName) {
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("aix")) {
            return AIX;
        }
        if (osName.contains("freebsd")) {
            return FREEBSD;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("mac")) {
            return MAC;
        }
        if (osName.contains("openbsd")) {
            return OPENBSD;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        return OTHER;
    }

    static {
        CURRENT_OS = OperatingSystem.determineCurrentOs();
    }
}

