/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphMatcher;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.graph.impl.SimpleTransactionHandler;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.ClosedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements GraphWithPerform {
    protected boolean closed = false;
    protected GraphEventManager gem;
    protected PrefixMapping pm = null;
    public static final int TOSTRING_TRIPLE_BASE = 10;
    public static final int TOSTRING_TRIPLE_LIMIT = 17;

    protected void checkOpen() {
        if (this.closed) {
            throw new ClosedException("already closed", this);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean dependsOn(Graph other) {
        return this == other;
    }

    @Override
    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager();
        }
        return this.gem;
    }

    public void notifyAdd(Triple t) {
        this.getEventManager().notifyAddTriple(this, t);
    }

    public void notifyDelete(Triple t) {
        this.getEventManager().notifyDeleteTriple(this, t);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        if (this.pm == null) {
            this.pm = this.createPrefixMapping();
        }
        return this.pm;
    }

    protected PrefixMapping createPrefixMapping() {
        return new PrefixMappingImpl();
    }

    @Override
    public void add(Triple t) {
        this.checkOpen();
        this.performAdd(t);
        this.notifyAdd(t);
    }

    @Override
    public void performAdd(Triple t) {
        throw new AddDeniedException("GraphBase::performAdd");
    }

    @Override
    public final void delete(Triple t) {
        this.checkOpen();
        this.performDelete(t);
        this.notifyDelete(t);
    }

    @Override
    public void performDelete(Triple t) {
        throw new DeleteDeniedException("GraphBase::delete");
    }

    @Override
    public void clear() {
        GraphUtil.remove(this, Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        GraphUtil.remove(this, s, p, o);
        this.getEventManager().notifyEvent(this, GraphEvents.remove(s, p, o));
    }

    @Override
    public final ExtendedIterator<Triple> find(Triple m) {
        this.checkOpen();
        return this.graphBaseFind(m);
    }

    protected abstract ExtendedIterator<Triple> graphBaseFind(Triple var1);

    public ExtendedIterator<Triple> forTestingOnly_graphBaseFind(Triple t) {
        return this.graphBaseFind(t);
    }

    @Override
    public final ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        this.checkOpen();
        return this.graphBaseFind(s, p, o);
    }

    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        return this.find(Triple.createMatch(s, p, o));
    }

    @Override
    public final boolean contains(Triple t) {
        this.checkOpen();
        return this.graphBaseContains(t);
    }

    protected boolean graphBaseContains(Triple t) {
        return this.containsByFind(t);
    }

    @Override
    public final boolean contains(Node s, Node p, Node o) {
        this.checkOpen();
        return this.contains(Triple.createMatch(s, p, o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple t) {
        try (ExtendedIterator<Triple> it = this.find(t);){
            boolean bl = it.hasNext();
            return bl;
        }
    }

    @Override
    public final int size() {
        this.checkOpen();
        return this.graphBaseSize();
    }

    protected int graphBaseSize() {
        try (ExtendedIterator<Triple> it = GraphUtil.findAll(this);){
            int n = (int)Iter.count(it);
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.contains(Triple.ANY);
    }

    @Override
    public boolean isIsomorphicWith(Graph g) {
        this.checkOpen();
        return g != null && GraphMatcher.equals(this, g);
    }

    public String toString() {
        return GraphBase.toString(this.closed ? "closed " : "", this);
    }

    public static String toString(String prefix, Graph that) {
        PrefixMapping pm = that.getPrefixMapping();
        StringBuilder b = new StringBuilder(prefix + " {");
        String gap = "";
        ExtendedIterator<Triple> it = GraphUtil.findAll(that);
        for (int count = 0; it.hasNext() && count < 17; ++count) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString(pm));
        }
        if (it.hasNext()) {
            b.append("...");
        }
        it.close();
        b.append("}");
        return b.toString();
    }
}

