/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Symbol;

public class QueryIteratorCheck
extends QueryIteratorWrapper {
    private ExecutionContext execCxt;
    public static Symbol failOnOpenIterator = SystemARQ.allocSymbol("failOnOpenIterator");

    private QueryIteratorCheck(QueryIterator qIter, ExecutionContext execCxt) {
        super(qIter);
        if (qIter instanceof QueryIteratorCheck) {
            Log.warn(this, "Checking checked iterator");
        }
        this.execCxt = execCxt;
    }

    @Override
    public void close() {
        super.close();
        QueryIteratorCheck.checkForOpenIterators(this.execCxt);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.iterator.output(out, sCxt);
    }

    public static void checkForOpenIterators(ExecutionContext execContext) {
        QueryIteratorCheck.dump(execContext, false);
    }

    public static QueryIteratorCheck check(QueryIterator qIter, ExecutionContext execCxt) {
        if (qIter instanceof QueryIteratorCheck) {
            return (QueryIteratorCheck)qIter;
        }
        return new QueryIteratorCheck(qIter, execCxt);
    }

    private static void dump(ExecutionContext execContext, boolean includeAll) {
        Iterator<QueryIterator> iterOpen;
        Iterator<QueryIterator> iterAll;
        if (includeAll && (iterAll = execContext.listAllIterators()) != null) {
            while (iterAll.hasNext()) {
                QueryIterator qIter = iterAll.next();
                QueryIteratorCheck.warn(qIter, "Iterator: ");
            }
        }
        if ((iterOpen = execContext.listOpenIterators()).hasNext()) {
            int i = 0;
            while (iterOpen.hasNext()) {
                QueryIterator qIterOpen = iterOpen.next();
                QueryIteratorCheck.warn(qIterOpen, "Open iterator [execCxt@" + System.identityHashCode(execContext) + "]: ");
                iterOpen.remove();
                ++i;
            }
            boolean enableException = execContext.getContext().get(failOnOpenIterator, false);
            if (enableException) {
                throw new OpenIteratorException("Unexpectedly encountered " + i + " open iterators.");
            }
        }
    }

    private static void warn(QueryIterator qIter, String str2) {
        str2 = (String)str2 + Lib.className(qIter);
        if (qIter instanceof QueryIteratorBase) {
            QueryIteratorBase qIterBase = (QueryIteratorBase)qIter;
            QueryIter qIterLN = (QueryIter)qIter;
            str2 = (String)str2 + "/" + qIterLN.getIteratorNumber();
        }
        Log.warn(QueryIteratorCheck.class, (String)str2);
    }

    public static class OpenIteratorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OpenIteratorException() {
        }

        public OpenIteratorException(Throwable cause) {
            super(cause);
        }

        public OpenIteratorException(String msg) {
            super(msg);
        }

        public OpenIteratorException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

