/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2StaxContentHandler
implements ContentHandler {
    private XMLStreamWriter xwriter;
    private List<PrefixMapping> prefixMappings;
    private boolean writeDocument = false;

    public SAX2StaxContentHandler(XMLStreamWriter writer, boolean writeDoc) {
        this.xwriter = writer;
        this.prefixMappings = new ArrayList<PrefixMapping>();
        this.writeDocument = writeDoc;
    }

    public SAX2StaxContentHandler(XMLStreamWriter writer) {
        this.xwriter = writer;
        this.prefixMappings = new ArrayList<PrefixMapping>();
        this.writeDocument = false;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.writeDocument) {
            try {
                this.xwriter.writeStartDocument();
                this.xwriter.flush();
            }
            catch (XMLStreamException xe) {
                throw new SAXException(xe);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.writeDocument) {
            try {
                this.xwriter.writeEndDocument();
                this.xwriter.flush();
            }
            catch (XMLStreamException xe) {
                throw new SAXException(xe);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.equals("xml")) {
            return;
        }
        this.prefixMappings.add(new PrefixMapping(prefix, uri));
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    private String getPrefix(String qname) {
        int index = qname.indexOf(":");
        String prefix = "";
        if (index > 0) {
            prefix = qname.substring(0, index);
        }
        return prefix;
    }

    @Override
    public void startElement(String ns, String local, String qname, Attributes attributes) throws SAXException {
        try {
            int i;
            String prefix = this.getPrefix(qname);
            this.xwriter.writeStartElement(prefix, local, ns);
            if (!this.prefixMappings.isEmpty()) {
                for (i = 0; i < this.prefixMappings.size(); ++i) {
                    PrefixMapping prefixMapping = this.prefixMappings.get(i);
                    String p = prefixMapping.prefix;
                    String u = prefixMapping.uri;
                    if (p.length() == 0) {
                        this.xwriter.setDefaultNamespace(u);
                    } else {
                        this.xwriter.setPrefix(p, u);
                    }
                    this.xwriter.writeNamespace(p, u);
                }
                this.prefixMappings.clear();
            }
            if (attributes != null) {
                for (i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String px = this.getPrefix(name);
                    String uri = attributes.getURI(i);
                    String value = attributes.getValue(i);
                    String localname = attributes.getLocalName(i);
                    if (px != null && px.equals("xmlns")) continue;
                    if (px != null && px.length() > 0) {
                        this.xwriter.writeAttribute(px, uri, localname, value);
                        continue;
                    }
                    this.xwriter.writeAttribute(localname, value);
                }
            }
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    @Override
    public void endElement(String string, String string1, String string2) throws SAXException {
        try {
            this.xwriter.writeEndElement();
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        try {
            this.xwriter.writeCharacters(chars, i, i1);
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        try {
            this.xwriter.writeCharacters(chars, i, i1);
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    @Override
    public void processingInstruction(String string, String string1) throws SAXException {
        try {
            this.xwriter.writeProcessingInstruction(string, string1);
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        try {
            this.xwriter.writeEntityRef(string);
        }
        catch (XMLStreamException xe) {
            throw new SAXException(xe);
        }
    }

    static class PrefixMapping {
        String prefix;
        String uri;

        PrefixMapping(String p, String u) {
            this.prefix = p == null ? "" : p;
            this.uri = u;
        }
    }
}

