/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiCommandList;
import com.cloudera.api.swagger.model.ApiCommandStep;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides detailed information about a submitted command including all steps and a summary of subcommands.  <p>There are two types of commands: synchronous and asynchronous. Synchronous commands complete immediately, and their results are passed back in the returned command object after the execution of an API call. Outside of that returned object, there is no way to check the result of a synchronous command.</p>  <p>Asynchronous commands have unique non-negative IDs. They may still be running when the API call returns. Clients can check the status of such commands using the API.</p>")
public class ApiCommandWithSteps {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="success")
    private Boolean success = null;
    @SerializedName(value="resultMessage")
    private String resultMessage = null;
    @SerializedName(value="resultDataUrl")
    private String resultDataUrl = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="serviceRef")
    private ApiServiceRef serviceRef = null;
    @SerializedName(value="roleRef")
    private ApiRoleRef roleRef = null;
    @SerializedName(value="hostRef")
    private ApiHostRef hostRef = null;
    @SerializedName(value="parent")
    private ApiCommand parent = null;
    @SerializedName(value="children")
    private ApiCommandList children = null;
    @SerializedName(value="canRetry")
    private Boolean canRetry = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="steps")
    private List<ApiCommandStep> steps = null;

    public ApiCommandWithSteps id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The command ID.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiCommandWithSteps name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The command name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCommandWithSteps startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiCommandWithSteps endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time, if the command is finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiCommandWithSteps active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Whether the command is currently active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ApiCommandWithSteps success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, whether it was successful.")
    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public ApiCommandWithSteps resultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, the result message.")
    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public ApiCommandWithSteps resultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
        return this;
    }

    @ApiModelProperty(value="URL to the command's downloadable result data, if any exists.")
    public String getResultDataUrl() {
        return this.resultDataUrl;
    }

    public void setResultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
    }

    public ApiCommandWithSteps clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the cluster (for cluster commands only).")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiCommandWithSteps serviceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the service (for service commands only).")
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApiCommandWithSteps roleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the role (for role commands only).")
    public ApiRoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public ApiCommandWithSteps hostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the host (for host commands only).")
    public ApiHostRef getHostRef() {
        return this.hostRef;
    }

    public void setHostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
    }

    public ApiCommandWithSteps parent(ApiCommand parent) {
        this.parent = parent;
        return this;
    }

    @ApiModelProperty(value="Reference to the parent command, if any.")
    public ApiCommand getParent() {
        return this.parent;
    }

    public void setParent(ApiCommand parent) {
        this.parent = parent;
    }

    public ApiCommandWithSteps children(ApiCommandList children) {
        this.children = children;
        return this;
    }

    @ApiModelProperty(value="List of child commands. Only available in the full view. <p> The list contains only the summary view of the children.")
    public ApiCommandList getChildren() {
        return this.children;
    }

    public void setChildren(ApiCommandList children) {
        this.children = children;
    }

    public ApiCommandWithSteps canRetry(Boolean canRetry) {
        this.canRetry = canRetry;
        return this;
    }

    @ApiModelProperty(value="If the command can be retried. Available since V11")
    public Boolean getCanRetry() {
        return this.canRetry;
    }

    public void setCanRetry(Boolean canRetry) {
        this.canRetry = canRetry;
    }

    public ApiCommandWithSteps displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The command display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiCommandWithSteps steps(List<ApiCommandStep> steps) {
        this.steps = steps;
        return this;
    }

    public ApiCommandWithSteps addStepsItem(ApiCommandStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<ApiCommandStep>();
        }
        this.steps.add(stepsItem);
        return this;
    }

    @ApiModelProperty(value="The steps of the command.")
    public List<ApiCommandStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<ApiCommandStep> steps) {
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommandWithSteps apiCommandWithSteps = (ApiCommandWithSteps)o;
        return Objects.equals(this.id, apiCommandWithSteps.id) && Objects.equals(this.name, apiCommandWithSteps.name) && Objects.equals(this.startTime, apiCommandWithSteps.startTime) && Objects.equals(this.endTime, apiCommandWithSteps.endTime) && Objects.equals(this.active, apiCommandWithSteps.active) && Objects.equals(this.success, apiCommandWithSteps.success) && Objects.equals(this.resultMessage, apiCommandWithSteps.resultMessage) && Objects.equals(this.resultDataUrl, apiCommandWithSteps.resultDataUrl) && Objects.equals(this.clusterRef, apiCommandWithSteps.clusterRef) && Objects.equals(this.serviceRef, apiCommandWithSteps.serviceRef) && Objects.equals(this.roleRef, apiCommandWithSteps.roleRef) && Objects.equals(this.hostRef, apiCommandWithSteps.hostRef) && Objects.equals(this.parent, apiCommandWithSteps.parent) && Objects.equals(this.children, apiCommandWithSteps.children) && Objects.equals(this.canRetry, apiCommandWithSteps.canRetry) && Objects.equals(this.displayName, apiCommandWithSteps.displayName) && Objects.equals(this.steps, apiCommandWithSteps.steps);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.startTime, this.endTime, this.active, this.success, this.resultMessage, this.resultDataUrl, this.clusterRef, this.serviceRef, this.roleRef, this.hostRef, this.parent, this.children, this.canRetry, this.displayName, this.steps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommandWithSteps {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    resultMessage: ").append(this.toIndentedString(this.resultMessage)).append("\n");
        sb.append("    resultDataUrl: ").append(this.toIndentedString(this.resultDataUrl)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    serviceRef: ").append(this.toIndentedString(this.serviceRef)).append("\n");
        sb.append("    roleRef: ").append(this.toIndentedString(this.roleRef)).append("\n");
        sb.append("    hostRef: ").append(this.toIndentedString(this.hostRef)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    canRetry: ").append(this.toIndentedString(this.canRetry)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

