/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A role config group contains roles of the same role type sharing the same configuration. While each role has to belong to a group, a role config group may be empty.  There exists a default role config group for each role type. Default groups cannot be removed nor created.  The name of a role config group is unique and cannot be changed.  The configuration of individual roles may be overridden on role level.")
public class ApiRoleConfigGroup {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="roleType")
    private String roleType = null;
    @SerializedName(value="base")
    private Boolean base = null;
    @SerializedName(value="config")
    private ApiConfigList config = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="serviceRef")
    private ApiServiceRef serviceRef = null;

    public ApiRoleConfigGroup name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Readonly. The unique name of this role config group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiRoleConfigGroup roleType(String roleType) {
        this.roleType = roleType;
        return this;
    }

    @Schema(description="Readonly. The type of the roles in this group.")
    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public ApiRoleConfigGroup base(Boolean base) {
        this.base = base;
        return this;
    }

    @Schema(description="Readonly. Indicates whether this is a base group.")
    public Boolean isBase() {
        return this.base;
    }

    public void setBase(Boolean base) {
        this.base = base;
    }

    public ApiRoleConfigGroup config(ApiConfigList config) {
        this.config = config;
        return this;
    }

    @Schema(description="")
    public ApiConfigList getConfig() {
        return this.config;
    }

    public void setConfig(ApiConfigList config) {
        this.config = config;
    }

    public ApiRoleConfigGroup displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The display name of this group.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiRoleConfigGroup serviceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
        return this;
    }

    @Schema(description="")
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRoleConfigGroup apiRoleConfigGroup = (ApiRoleConfigGroup)o;
        return Objects.equals(this.name, apiRoleConfigGroup.name) && Objects.equals(this.roleType, apiRoleConfigGroup.roleType) && Objects.equals(this.base, apiRoleConfigGroup.base) && Objects.equals(this.config, apiRoleConfigGroup.config) && Objects.equals(this.displayName, apiRoleConfigGroup.displayName) && Objects.equals(this.serviceRef, apiRoleConfigGroup.serviceRef);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roleType, this.base, this.config, this.displayName, this.serviceRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRoleConfigGroup {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roleType: ").append(this.toIndentedString(this.roleType)).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    serviceRef: ").append(this.toIndentedString(this.serviceRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

