/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.util.Internal;

@Internal
public final class EscherRecordHolder {
    private final ArrayList<EscherRecord> escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] data, int offset, int size) {
        this();
        this.fillEscherRecords(data, offset, size);
    }

    private void fillEscherRecords(byte[] data, int offset, int size) {
        int bytesRead;
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead + 1) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            this.escherRecords.add(r);
            bytesRead = r.fillFields(data, pos, (EscherRecordFactory)recordFactory);
        }
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded").append("\n");
        }
        for (EscherRecord r : this.escherRecords) {
            buffer.append(r);
        }
        return buffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord er : this.escherRecords) {
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short id) {
        return EscherRecordHolder.findFirstWithId(id, this.getEscherRecords());
    }

    private static EscherRecord findFirstWithId(short id, List<EscherRecord> records) {
        for (EscherRecord r : records) {
            if (r.getRecordId() != id) continue;
            return r;
        }
        for (EscherRecord r : records) {
            EscherRecord found;
            if (!r.isContainerRecord() || (found = EscherRecordHolder.findFirstWithId(id, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }

    public List<? extends EscherContainerRecord> getDgContainers() {
        ArrayList<EscherContainerRecord> dgContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4094) continue;
            dgContainers.add((EscherContainerRecord)escherRecord);
        }
        return dgContainers;
    }

    public List<? extends EscherContainerRecord> getDggContainers() {
        ArrayList<EscherContainerRecord> dggContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4096) continue;
            dggContainers.add((EscherContainerRecord)escherRecord);
        }
        return dggContainers;
    }

    public List<? extends EscherContainerRecord> getBStoreContainers() {
        ArrayList<EscherContainerRecord> bStoreContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDggContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4095) continue;
                bStoreContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return bStoreContainers;
    }

    public List<? extends EscherContainerRecord> getSpgrContainers() {
        ArrayList<EscherContainerRecord> spgrContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDgContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4093) continue;
                spgrContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spgrContainers;
    }

    public List<? extends EscherContainerRecord> getSpContainers() {
        ArrayList<EscherContainerRecord> spContainers = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getSpgrContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4092) continue;
                spContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spContainers;
    }
}

