/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.support.CompositeNamedLock;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedLockFactorySupport
implements NamedLockFactory {
    public static final String SYSTEM_PROP_DIAGNOSTIC_ENABLED = "aether.named.diagnostic.enabled";
    private static final boolean DIAGNOSTIC_ENABLED = Boolean.getBoolean("aether.named.diagnostic.enabled");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<NamedLockKey, NamedLockHolder> locks;
    private final AtomicInteger compositeCounter;
    private final boolean diagnosticEnabled;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public NamedLockFactorySupport() {
        this(DIAGNOSTIC_ENABLED);
    }

    public NamedLockFactorySupport(boolean diagnosticEnabled) {
        this.locks = new ConcurrentHashMap<NamedLockKey, NamedLockHolder>();
        this.compositeCounter = new AtomicInteger(0);
        this.diagnosticEnabled = diagnosticEnabled;
    }

    public boolean isDiagnosticEnabled() {
        return this.diagnosticEnabled;
    }

    @Override
    public final NamedLock getLock(Collection<NamedLockKey> keys) {
        Objects.requireNonNull(keys, "keys");
        if (this.shutdown.get()) {
            throw new IllegalStateException("factory already shut down");
        }
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("empty keys");
        }
        return this.doGetLock(keys);
    }

    protected NamedLock doGetLock(Collection<NamedLockKey> keys) {
        if (keys.size() == 1) {
            NamedLockKey key = keys.iterator().next();
            return this.getLockAndRefTrack(key, () -> this.createLock(key));
        }
        return new CompositeNamedLock(NamedLockKey.of("composite-" + this.compositeCounter.incrementAndGet(), keys.stream().map(NamedLockKey::resources).flatMap(Collection::stream).collect(Collectors.toList())), this, keys.stream().map(k -> this.getLockAndRefTrack((NamedLockKey)k, () -> this.createLock((NamedLockKey)k))).collect(Collectors.toList()));
    }

    protected NamedLock getLockAndRefTrack(NamedLockKey key, Supplier<NamedLockSupport> supplier) {
        return this.locks.compute(key, (k, v) -> {
            if (v == null) {
                v = new NamedLockHolder((NamedLockSupport)supplier.get());
            }
            return ((NamedLockHolder)v).incRef();
        }).namedLock;
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.doShutdown();
        }
    }

    protected void doShutdown() {
    }

    @Override
    public <E extends Throwable> E onFailure(E failure) {
        if (this.isDiagnosticEnabled()) {
            HashMap<NamedLockKey, NamedLockHolder> locks = new HashMap<NamedLockKey, NamedLockHolder>(this.locks);
            int activeLocks = locks.size();
            this.logger.info("Diagnostic dump of lock factory");
            this.logger.info("===============================");
            this.logger.info("Implementation: {}", (Object)this.getClass().getName());
            this.logger.info("Active locks: {}", (Object)activeLocks);
            this.logger.info("");
            if (activeLocks > 0) {
                for (Map.Entry entry : locks.entrySet()) {
                    NamedLockKey key = (NamedLockKey)entry.getKey();
                    int refCount = ((NamedLockHolder)entry.getValue()).referenceCount.get();
                    NamedLockSupport lock = ((NamedLockHolder)entry.getValue()).namedLock;
                    this.logger.info("Name: {}", (Object)key.name());
                    this.logger.info("RefCount: {}", (Object)refCount);
                    this.logger.info("Resources:");
                    key.resources().forEach(r -> this.logger.info(" - {}", r));
                    Map<Thread, Deque<String>> diag = lock.diagnosticState();
                    this.logger.info("State:");
                    diag.forEach((k, v) -> this.logger.info("  {} -> {}", k, v));
                }
                this.logger.info("");
            }
        }
        return failure;
    }

    public void closeLock(NamedLockKey key) {
        this.locks.compute(key, (k, v) -> {
            if (v != null && ((NamedLockHolder)v).decRef() == 0) {
                this.destroyLock(((NamedLockHolder)v).namedLock);
                return null;
            }
            return v;
        });
    }

    protected abstract NamedLockSupport createLock(NamedLockKey var1);

    protected void destroyLock(NamedLock namedLock) {
    }

    private static final class NamedLockHolder {
        private final NamedLockSupport namedLock;
        private final AtomicInteger referenceCount;

        private NamedLockHolder(NamedLockSupport namedLock) {
            this.namedLock = Objects.requireNonNull(namedLock);
            this.referenceCount = new AtomicInteger(0);
        }

        private NamedLockHolder incRef() {
            this.referenceCount.incrementAndGet();
            return this;
        }

        private int decRef() {
            return this.referenceCount.decrementAndGet();
        }

        public String toString() {
            return "[refCount=" + this.referenceCount.get() + ", lock=" + this.namedLock + "]";
        }
    }
}

