/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneChoice;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleSelectOneChoiceRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _unselectedLabelKey;
    private static final String _SYNC_FUNC = "_syncChoiceIndex(this)";
    private static final String _IE_ACTION_HANDLER_PREFIX = "if(!_pprChoiceAction(event))return true;";
    private static final String _CHOICE_CHANGE_TRACKER = "return _pprChoiceChangeEvent(event);";

    public SimpleSelectOneChoiceRenderer() {
        this(CoreSelectOneChoice.TYPE);
    }

    public SimpleSelectOneChoiceRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean, false);
        this.encodeSelectItems(context, rc, component, bean, selectItems, selectedIndex, converter, valuePassThru);
        writer.endElement("select");
    }

    protected void encodeSelectItems(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        int size = selectItems == null ? 0 : selectItems.size();
        String unselectedLabel = this.getUnselectedLabel(component, bean);
        boolean needsUnselectedLabel = false;
        if (size > 0 && selectedIndex < 0) {
            needsUnselectedLabel = true;
        } else if (unselectedLabel != null) {
            needsUnselectedLabel = true;
        }
        if (needsUnselectedLabel) {
            if (unselectedLabel == null) {
                unselectedLabel = "";
            }
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            SimpleSelectOneChoiceRenderer.encodeOption(context, rc, component, item, null, true, -1, false);
        }
        for (int i = 0; i < size; ++i) {
            SelectItem item = selectItems.get(i);
            SimpleSelectOneChoiceRenderer.encodeOption(context, rc, component, item, converter, valuePassThru, i, selectedIndex == i);
        }
    }

    @Override
    protected String getOnclick(UIComponent component, FacesBean bean) {
        RenderingContext rc = RenderingContext.getCurrentInstance();
        String onclick = super.getOnclick(component, bean);
        if (SimpleSelectOneChoiceRenderer.isIE((RenderingContext)rc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)rc) && this.isAutoSubmit(component, bean)) {
            String auto = this.getAutoSubmitScript(rc, component, bean);
            auto = _IE_ACTION_HANDLER_PREFIX + auto;
            onclick = XhtmlUtils.getChainedJS(onclick, auto, true);
        }
        return onclick;
    }

    @Override
    protected String getOnblur(UIComponent component, FacesBean bean) {
        RenderingContext rc = RenderingContext.getCurrentInstance();
        String onblur = super.getOnblur(component, bean);
        if (SimpleSelectOneChoiceRenderer.isIE((RenderingContext)rc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)rc) && this.isAutoSubmit(component, bean)) {
            String auto = this.getAutoSubmitScript(rc, component, bean);
            auto = _IE_ACTION_HANDLER_PREFIX + auto;
            onblur = XhtmlUtils.getChainedJS(onblur, auto, true);
        }
        return onblur;
    }

    @Override
    protected String getOnchange(UIComponent component, FacesBean bean) {
        RenderingContext rc = RenderingContext.getCurrentInstance();
        String onchange = super.getOnchange(component, bean);
        String auto = null;
        if (this.isAutoSubmit(component, bean)) {
            auto = SimpleSelectOneChoiceRenderer.isIE((RenderingContext)rc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)rc) ? _CHOICE_CHANGE_TRACKER : this.getAutoSubmitScript(rc, component, bean);
        }
        if (SimpleSelectOneChoiceRenderer._isRepeatingRegion(rc)) {
            auto = auto == null ? _SYNC_FUNC : "_syncChoiceIndex(this);" + auto;
        }
        return XhtmlUtils.getChainedJS(onchange, auto, true);
    }

    @Override
    protected String getUnselectedLabel(UIComponent component, FacesBean bean) {
        return SimpleSelectOneChoiceRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneChoice::content";
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneChoice";
    }

    private static boolean _isRepeatingRegion(RenderingContext rc) {
        return rc.getProperties().get(XhtmlConstants.REPEAT_PROPERTY) != null;
    }
}

