/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.style.ParsedPropertyKey;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;

public abstract class BaseStyle
extends CoreStyle
implements Serializable {
    private volatile Map<String, String> _propertiesMap;
    private transient Object[] _parsedProperties;
    private static final int _PARSED_PROPERTIES_COUNT = 7;
    private static final Object _NULL_VALUE = new Object();
    private static final long serialVersionUID = 1L;

    public BaseStyle() {
        this._propertiesMap = Collections.emptyMap();
    }

    public BaseStyle(Map<String, String> propertiesMap) {
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            this._propertiesMap = new ConcurrentHashMap<String, String>(propertiesMap.size());
            this._propertiesMap.putAll(propertiesMap);
        } else {
            this._propertiesMap = Collections.emptyMap();
        }
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._propertiesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getParsedProperty(ParsedPropertyKey key) throws PropertyParseException {
        Object value = null;
        int index = key.getKeyIndex();
        if (this._parsedProperties != null) {
            value = this._parsedProperties[index];
            if (value != null) {
                if (value == _NULL_VALUE) {
                    value = null;
                }
                return value;
            }
        } else {
            BaseStyle baseStyle = this;
            synchronized (baseStyle) {
                if (this._parsedProperties == null) {
                    this._parsedProperties = new Object[7];
                }
            }
        }
        try {
            value = this.parseProperty(key);
        }
        catch (PropertyParseException e) {
            this._parsedProperties[index] = _NULL_VALUE;
            throw e;
        }
        this._parsedProperties[index] = value == null ? _NULL_VALUE : value;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        BaseStyle baseStyle = this;
        synchronized (baseStyle) {
            if (this._propertiesMap.isEmpty()) {
                this._propertiesMap = new ConcurrentHashMap<String, String>();
            }
            this._propertiesMap.put(name, value);
            this._parsedProperties = null;
        }
    }

    public abstract String toInlineString();

    protected abstract Object parseProperty(Object var1) throws PropertyParseException;
}

