/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterToken;
import org.apache.nifi.parameter.ParameterTokenList;

public class StandardParameterTokenList
implements ParameterTokenList {
    private final String input;
    private final List<ParameterToken> tokens;
    private final List<ParameterReference> referenceList;

    public StandardParameterTokenList(String input, List<ParameterToken> tokens) {
        this.input = input;
        this.tokens = tokens;
        this.referenceList = tokens.stream().filter(ParameterToken::isParameterReference).map(token -> (ParameterReference)token).collect(Collectors.toList());
    }

    @Override
    public List<ParameterReference> toReferenceList() {
        return this.referenceList;
    }

    @Override
    public String substitute(ParameterLookup parameterLookup) {
        if (this.input == null) {
            return null;
        }
        if (this.tokens.isEmpty()) {
            return this.input;
        }
        return this.substitute((ParameterToken reference) -> reference.getValue(parameterLookup));
    }

    @Override
    public String escape() {
        if (this.input == null) {
            return null;
        }
        return this.substitute((ParameterToken reference) -> {
            if (reference.isEscapeSequence()) {
                if (reference.getText().equals("##")) {
                    return "####";
                }
                return "##" + reference.getText();
            }
            return "#" + reference.getText();
        });
    }

    private String substitute(Function<ParameterToken, String> transform) {
        StringBuilder sb = new StringBuilder();
        int nullCount = 0;
        int lastEndOffset = -1;
        for (ParameterToken token : this.tokens) {
            int startOffset = token.getStartOffset();
            sb.append(this.input, lastEndOffset + 1, startOffset);
            String transformed = transform.apply(token);
            if (transformed == null) {
                ++nullCount;
            } else {
                sb.append(transformed);
            }
            lastEndOffset = token.getEndOffset();
        }
        if (this.input.length() > lastEndOffset + 1) {
            sb.append(this.input, lastEndOffset + 1, this.input.length());
        }
        String substituted = sb.toString();
        if (nullCount == this.tokens.size() && !this.tokens.isEmpty() && substituted.isEmpty()) {
            return null;
        }
        return substituted;
    }

    @Override
    public List<ParameterToken> toList() {
        return Collections.unmodifiableList(this.tokens);
    }

    @Override
    public Iterator<ParameterToken> iterator() {
        return this.tokens.iterator();
    }
}

