/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.query.engine.cache.MaxSizeHashMap;
import org.apache.qpid.server.query.engine.evaluator.QueryEvaluator;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;

public class QueryEngine {
    private final Broker<?> _broker;
    private Map<String, QueryExpression<?, ?>> _queryCache;
    private BigDecimal _maxBigDecimalValue = BigDecimal.valueOf(Double.MAX_VALUE).pow(4);
    private int _maxQueryCacheSize;
    private int _maxQueryDepth;
    private ZoneId _zoneId;

    public QueryEngine(Broker<?> broker) {
        Objects.requireNonNull(broker, "Broker instance not provided for querying");
        this._broker = broker;
    }

    public void initQueryCache() {
        this._queryCache = this._maxQueryCacheSize > 0 ? new MaxSizeHashMap(this._maxQueryCacheSize) : null;
    }

    public QueryEvaluator createEvaluator() {
        QuerySettings defaultQuerySettings = new QuerySettings();
        defaultQuerySettings.setMaxBigDecimalValue(this._maxBigDecimalValue);
        defaultQuerySettings.setMaxQueryCacheSize(this._maxQueryCacheSize);
        defaultQuerySettings.setMaxQueryDepth(this._maxQueryDepth);
        defaultQuerySettings.setZoneId(this._zoneId);
        return new QueryEvaluator(this._queryCache, defaultQuerySettings, this._broker);
    }

    public void setMaxBigDecimalValue(BigDecimal maxBigDecimalValue) {
        this._maxBigDecimalValue = maxBigDecimalValue;
    }

    public void setMaxQueryCacheSize(int maxQueryCacheSize) {
        this._maxQueryCacheSize = maxQueryCacheSize;
    }

    public void setMaxQueryDepth(int maxQueryDepth) {
        this._maxQueryDepth = maxQueryDepth;
    }

    public void setZoneId(ZoneId zoneId) {
        this._zoneId = zoneId;
    }

    public int getCacheSize() {
        return this._queryCache == null ? 0 : this._queryCache.size();
    }
}

