/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.framing.FieldTable;

public final class JMSHeaderAdapter {
    private static final Map<String, String> AMQP_TO_JMS_HEADER_NAME_MAPPINGS;
    private static final Map<String, String> JMS_TO_AMQP_HEADER_NAME_MAPPINGS;
    private static final boolean STRICT_JMS;
    private final FieldTable _headers;

    public JMSHeaderAdapter(FieldTable headers) {
        this._headers = headers;
    }

    private String mapJmsToAmqpName(String name) {
        return JMS_TO_AMQP_HEADER_NAME_MAPPINGS.containsKey(name) ? JMS_TO_AMQP_HEADER_NAME_MAPPINGS.get(name) : name;
    }

    public boolean getBoolean(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Boolean b = this._headers.getBoolean(amqpName);
        if (b == null) {
            if (this._headers.containsKey(amqpName)) {
                Object str = this._headers.getObject(amqpName);
                if (!(str instanceof String)) {
                    throw new MessageFormatException("getBoolean can't use " + name + " item.");
                }
                return Boolean.valueOf((String)str);
            }
            b = Boolean.valueOf(null);
        }
        return b;
    }

    public byte[] getBytes(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        byte[] bs = this._headers.getBytes(amqpName);
        if (bs == null) {
            throw new MessageFormatException("getBytes can't use " + name + " item.");
        }
        return bs;
    }

    public byte getByte(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Byte b = this._headers.getByte(amqpName);
        if (b == null) {
            if (this._headers.containsKey(amqpName)) {
                Object str = this._headers.getObject(amqpName);
                if (!(str instanceof String)) {
                    throw new MessageFormatException("getByte can't use " + name + " item.");
                }
                return Byte.valueOf((String)str);
            }
            b = Byte.valueOf(null);
        }
        return b;
    }

    public short getShort(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Short s = this._headers.getShort(amqpName);
        if (s == null) {
            s = this.getByte(amqpName);
        }
        return s;
    }

    public int getInteger(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Integer i = this._headers.getInteger(amqpName);
        if (i == null) {
            i = this.getShort(amqpName);
        }
        return i;
    }

    public long getLong(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Long l = this._headers.getLong(amqpName);
        if (l == null) {
            l = this.getInteger(amqpName);
        }
        return l;
    }

    public float getFloat(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Float f = this._headers.getFloat(amqpName);
        if (f == null) {
            if (this._headers.containsKey(amqpName)) {
                Object str = this._headers.getObject(amqpName);
                if (!(str instanceof String)) {
                    throw new MessageFormatException("getFloat can't use " + name + " item.");
                }
                return Float.valueOf((String)str).floatValue();
            }
            throw new NullPointerException("No such property: " + name);
        }
        return f.floatValue();
    }

    public double getDouble(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        Double d = this._headers.getDouble(amqpName);
        if (d == null) {
            d = this.getFloat(amqpName);
        }
        return d;
    }

    public String getString(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        String s = this._headers.getString(amqpName);
        if (s == null && this._headers.containsKey(amqpName)) {
            Object o = this._headers.getObject(amqpName);
            if (o instanceof byte[]) {
                throw new MessageFormatException("getObject couldn't find " + name + " item.");
            }
            if (o == null) {
                return null;
            }
            s = String.valueOf(o);
        }
        return s;
    }

    public Object getObject(String name) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        return this._headers.getObject(amqpName);
    }

    public void setBoolean(String name, boolean b) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setBoolean(amqpName, (Boolean)b);
    }

    public void setByte(String name, byte b) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setByte(amqpName, (Byte)b);
    }

    public void setShort(String name, short i) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setShort(amqpName, (Short)i);
    }

    public void setInteger(String name, int i) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setInteger(amqpName, i);
    }

    public void setLong(String name, long l) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setLong(amqpName, l);
    }

    public void setFloat(String name, float v) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setFloat(amqpName, Float.valueOf(v));
    }

    public void setDouble(String name, double v) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setDouble(amqpName, (Double)v);
    }

    public void setString(String name, String value) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        this._headers.setString(amqpName, value);
    }

    public void setObject(String name, Object object) throws JMSException {
        this.checkPropertyName(name);
        String amqpName = this.mapJmsToAmqpName(name);
        try {
            this._headers.setObject(amqpName, object);
        }
        catch (AMQPInvalidClassException aice) {
            String msg = "Only Primitive objects allowed. Object is: " + (object == null ? "null" : object.getClass());
            throw JMSExceptionHelper.chainJMSException((JMSException)new MessageFormatException(msg), aice);
        }
    }

    public Set<String> getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(this._headers.keys());
        for (Map.Entry<String, String> entry : AMQP_TO_JMS_HEADER_NAME_MAPPINGS.entrySet()) {
            if (!names.contains(entry.getKey())) continue;
            names.add(entry.getValue());
            if (!STRICT_JMS) continue;
            names.remove(entry.getKey());
        }
        return names;
    }

    public void clear() {
        this._headers.clear();
    }

    public boolean propertyExists(String name) {
        this.checkPropertyName(name);
        String propertyName = this.mapJmsToAmqpName(name);
        return this._headers.propertyExists(propertyName);
    }

    public Object remove(String name) {
        this.checkPropertyName(name);
        String propertyName = this.mapJmsToAmqpName(name);
        return this._headers.remove(propertyName);
    }

    public boolean isEmpty() {
        return this._headers.isEmpty();
    }

    protected void checkPropertyName(CharSequence propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        this.checkIdentifierFormat(propertyName);
    }

    protected void checkIdentifierFormat(CharSequence propertyName) {
        if (STRICT_JMS) {
            if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid JMS identifier start character");
            }
            int length = propertyName.length();
            for (int c = 1; c < length; ++c) {
                if (Character.isJavaIdentifierPart(propertyName.charAt(c))) continue;
                throw new IllegalArgumentException("Identifier '" + propertyName + "' contains an invalid JMS identifier character");
            }
            if (propertyName.equals("NULL") || propertyName.equals("TRUE") || propertyName.equals("FALSE") || propertyName.equals("NOT") || propertyName.equals("AND") || propertyName.equals("OR") || propertyName.equals("BETWEEN") || propertyName.equals("LIKE") || propertyName.equals("IN") || propertyName.equals("IS") || propertyName.equals("ESCAPE")) {
                throw new IllegalArgumentException("Identifier '" + propertyName + "' is not allowed in JMS");
            }
        }
    }

    static {
        String[][] mappings = new String[][]{{"qpid.subject", "JMS_qpid_subject"}};
        HashMap<String, String> amqpToJmsHeaderNameMappings = new HashMap<String, String>();
        HashMap<String, String> jmsToAmqpHeaderNameMappings = new HashMap<String, String>();
        for (String[] mapping : mappings) {
            amqpToJmsHeaderNameMappings.put(mapping[0], mapping[1]);
            jmsToAmqpHeaderNameMappings.put(mapping[1], mapping[0]);
        }
        AMQP_TO_JMS_HEADER_NAME_MAPPINGS = Collections.unmodifiableMap(amqpToJmsHeaderNameMappings);
        JMS_TO_AMQP_HEADER_NAME_MAPPINGS = Collections.unmodifiableMap(jmsToAmqpHeaderNameMappings);
        STRICT_JMS = Boolean.getBoolean("strict-jms");
    }
}

