/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.common.message.MessageExt;

public class MessageUtils {
    public static int getShardingKeyIndex(String shardingKey, int indexSize) {
        return Math.abs(Hashing.murmur3_32().hashBytes(shardingKey.getBytes(StandardCharsets.UTF_8)).asInt() % indexSize);
    }

    public static int getShardingKeyIndexByMsg(MessageExt msg, int indexSize) {
        String shardingKey = msg.getProperty("__SHARDINGKEY");
        if (shardingKey == null) {
            shardingKey = "";
        }
        return MessageUtils.getShardingKeyIndex(shardingKey, indexSize);
    }

    public static Set<Integer> getShardingKeyIndexes(Collection<MessageExt> msgs, int indexSize) {
        HashSet<Integer> indexSet = new HashSet<Integer>(indexSize);
        for (MessageExt msg : msgs) {
            indexSet.add(MessageUtils.getShardingKeyIndexByMsg(msg, indexSize));
        }
        return indexSet;
    }

    public static String deleteProperty(String propertiesString, String name) {
        int idx0;
        int idx1;
        if (propertiesString != null && (idx1 = propertiesString.indexOf(name, idx0 = 0)) != -1) {
            StringBuilder stringBuilder = new StringBuilder(propertiesString.length());
            while (true) {
                int startIdx = idx0;
                while ((idx1 = propertiesString.indexOf(name, startIdx)) != -1) {
                    startIdx = idx1 + name.length();
                    if (idx1 != 0 && propertiesString.charAt(idx1 - 1) != '\u0002' || propertiesString.length() <= idx1 + name.length() || propertiesString.charAt(idx1 + name.length()) != '\u0001') continue;
                }
                if (idx1 == -1) {
                    stringBuilder.append(propertiesString, idx0, propertiesString.length());
                    break;
                }
                stringBuilder.append(propertiesString, idx0, idx1);
                int idx2 = propertiesString.indexOf(2, idx1 + name.length() + 1);
                if (idx2 == -1) break;
                idx0 = idx2 + 1;
            }
            return stringBuilder.toString();
        }
        return propertiesString;
    }
}

